/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.FactoryRDFStd;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.vocabulary.RDF;
import org.junit.Assert;
import org.junit.Test;

public class TestFactoryRDF {
    protected FactoryRDF factory = new FactoryRDFStd(LabelToNode.createUseLabelAsGiven());

    @Test
    public void factoryRDF_blanknode_01() {
        Node n1 = this.factory.createBlankNode();
        Assert.assertTrue((boolean)n1.isBlank());
        Node n2 = this.factory.createBlankNode();
        Assert.assertNotEquals((Object)n1, (Object)n2);
    }

    @Test
    public void factoryRDF_blanknode_02() {
        Node n1 = this.factory.createBlankNode("ABCDE");
        Assert.assertTrue((boolean)n1.isBlank());
        Node n2 = this.factory.createBlankNode("ABCDE");
        Assert.assertEquals((Object)n1, (Object)n2);
        Assert.assertEquals((Object)"ABCDE", (Object)n1.getBlankNodeLabel());
    }

    @Test
    public void factoryRDF_blanknode_03() {
        Node n1 = this.factory.createBlankNode(4660L, 22136L);
        Assert.assertTrue((boolean)n1.isBlank());
        Node n2 = this.factory.createBlankNode(4660L, 22136L);
        Assert.assertEquals((Object)n1, (Object)n2);
        Assert.assertEquals((Object)"0000123400005678", (Object)n1.getBlankNodeLabel());
    }

    @Test
    public void factoryRDF_uri_02() {
        Node n = this.factory.createURI("http://example/");
        Assert.assertTrue((boolean)n.isURI());
        Assert.assertEquals((Object)"http://example/", (Object)n.getURI());
    }

    @Test
    public void factoryRDF_uri_03() {
        Node n = this.factory.createURI("_:abc");
        Assert.assertTrue((boolean)n.isBlank());
        Assert.assertEquals((Object)"abc", (Object)n.getBlankNodeLabel());
    }

    @Test
    public void factoryRDF_literal_01() {
        Node n = this.factory.createStringLiteral("hello");
        Assert.assertTrue((boolean)n.isLiteral());
        Assert.assertEquals((Object)"hello", (Object)n.getLiteralLexicalForm());
        Assert.assertEquals((Object)XSDDatatype.XSDstring, (Object)n.getLiteralDatatype());
        Assert.assertEquals((Object)"", (Object)n.getLiteralLanguage());
    }

    @Test
    public void factoryRDF_literal_02() {
        Node n = this.factory.createLangLiteral("xyz", "en");
        Assert.assertTrue((boolean)n.isLiteral());
        Assert.assertEquals((Object)"xyz", (Object)n.getLiteralLexicalForm());
        Assert.assertEquals((Object)RDF.dtLangString, (Object)n.getLiteralDatatype());
        Assert.assertEquals((Object)"en", (Object)n.getLiteralLanguage());
    }

    @Test
    public void factoryRDF_literal_03() {
        Node n = this.factory.createTypedLiteral("1", (RDFDatatype)XSDDatatype.XSDinteger);
        Assert.assertTrue((boolean)n.isLiteral());
        Assert.assertEquals((Object)"1", (Object)n.getLiteralLexicalForm());
        Assert.assertEquals((Object)XSDDatatype.XSDinteger, (Object)n.getLiteralDatatype());
        Assert.assertEquals((Object)"", (Object)n.getLiteralLanguage());
    }

    @Test
    public void factoryRDF_triple_01() {
        Node s = this.factory.createURI("http://test/s");
        Node p = this.factory.createURI("http://test/p");
        Node o = this.factory.createURI("http://test/o");
        Triple triple = this.factory.createTriple(s, p, o);
        Assert.assertEquals((Object)s, (Object)triple.getSubject());
        Assert.assertEquals((Object)p, (Object)triple.getPredicate());
        Assert.assertEquals((Object)o, (Object)triple.getObject());
    }

    @Test
    public void factoryRDF_quad_01() {
        Node g = this.factory.createURI("http://test/g");
        Node s = this.factory.createURI("http://test/s");
        Node p = this.factory.createURI("http://test/p");
        Node o = this.factory.createURI("http://test/o");
        Quad quad = this.factory.createQuad(g, s, p, o);
        Assert.assertEquals((Object)g, (Object)quad.getGraph());
        Assert.assertEquals((Object)s, (Object)quad.getSubject());
        Assert.assertEquals((Object)p, (Object)quad.getPredicate());
        Assert.assertEquals((Object)o, (Object)quad.getObject());
    }
}

