/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import org.apache.jena.graph.Triple;
import org.apache.jena.riot.ErrorHandlerTestLib;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.lang.ParserTestBaseLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.sse.SSE;
import org.junit.Assert;
import org.junit.Test;

public class TestLangTrig {
    @Test
    public void trig_01() {
        TestLangTrig.parse("{}");
    }

    @Test
    public void trig_02() {
        TestLangTrig.parse("{}.");
    }

    @Test
    public void trig_03() {
        TestLangTrig.parse("<g> {}");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void trig_04() {
        TestLangTrig.parse("<g> = {}");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void trig_05() {
        TestLangTrig.parse("<g> = {} .");
    }

    @Test
    public void trig_10() {
        DatasetGraph dsg = TestLangTrig.parse("{ <x> <p> <q> }");
        Assert.assertEquals((long)1L, (long)dsg.getDefaultGraph().size());
        Triple t = (Triple)dsg.getDefaultGraph().find(null, null, null).next();
        Triple t2 = SSE.parseTriple((String)"(<http://base/x> <http://base/p> <http://base/q>)");
        Assert.assertEquals((Object)t2, (Object)t);
    }

    @Test
    public void trig_11() {
        DatasetGraph dsg = TestLangTrig.parse("@prefix ex:  <http://example/> .", "{ ex:s ex:p 123 }");
        Assert.assertEquals((long)1L, (long)dsg.getDefaultGraph().size());
        Triple t = (Triple)dsg.getDefaultGraph().find(null, null, null).next();
        Triple t2 = SSE.parseTriple((String)"(<http://example/s> <http://example/p> 123)");
    }

    @Test
    public void trig_12() {
        TestLangTrig.parse("@prefix xsd:  <http://www.w3.org/2001/XMLSchema#> .", "{ <x> <p> '1'^^xsd:byte }");
    }

    @Test(expected=ErrorHandlerTestLib.ExError.class)
    public void trig_20() {
        TestLangTrig.parse("@prefix ex:  <bad iri> .", "{ ex:s ex:p 123 }");
    }

    @Test(expected=ErrorHandlerTestLib.ExError.class)
    public void trig_21() {
        TestLangTrig.parse("@prefix ex:  <http://example/> .", "{ ex:s <http://example/broken p> 123 }");
    }

    @Test(expected=ErrorHandlerTestLib.ExError.class)
    public void trig_22() {
        TestLangTrig.parse("{ <x> <p> 'number'^^<bad uri> }");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void trig_23() {
        TestLangTrig.parse("@prefix xsd:  <http://www.w3.org/2001/XMLSchema#> .", "{ <x> <p> 'number'^^xsd:byte }");
    }

    private static DatasetGraph parse(String ... strings) {
        return ParserTestBaseLib.parseDataset(Lang.TRIG, strings);
    }
}

