/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import org.apache.jena.graph.Graph;
import org.apache.jena.riot.ErrorHandlerTestLib;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.graph.GraphFactory;

class ParserTestBaseLib {
    ParserTestBaseLib() {
    }

    static Graph parseGraph(Lang lang, String ... strings) {
        Graph graph = GraphFactory.createDefaultGraph();
        StreamRDF dest = StreamRDFLib.graph((Graph)graph);
        ParserTestBaseLib.parse(lang, dest, strings);
        return graph;
    }

    static DatasetGraph parseDataset(Lang lang, String ... strings) {
        DatasetGraph dsg = DatasetGraphFactory.create();
        StreamRDF dest = StreamRDFLib.dataset((DatasetGraph)dsg);
        ParserTestBaseLib.parse(lang, dest, strings);
        return dsg;
    }

    static void parse(Lang lang, StreamRDF dest, String ... strings) {
        String string = String.join((CharSequence)"\n", strings);
        String baseIRI = "http://base/";
        RDFParser.create().fromString(string).base(baseIRI).errorHandler((ErrorHandler)new ErrorHandlerTestLib.ErrorHandlerEx()).lang(lang).parse(dest);
    }

    static long parseCount(Lang lang, String ... strings) {
        StreamRDFCounting dest = StreamRDFLib.count();
        ParserTestBaseLib.parse(lang, (StreamRDF)dest, strings);
        return dest.count();
    }
}

