/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.ListUtils;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.StreamOps;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfs.engine.ConstRDFS;
import org.apache.jena.reasoner.rulesys.GenericRuleReasoner;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.util.FileUtils;

public class LibTestRDFS {
    public static List<Triple> removeRDFS(List<Triple> x) {
        return StreamOps.toList(x.stream().filter(ConstRDFS.filterNotRDFS));
    }

    static Graph createRulesGraph(Graph data, Graph vocab, String rulesFile) {
        try {
            String rules = FileUtils.readWholeFileAsUTF8((String)rulesFile);
            rules = rules.replaceAll("#[^\\n]*", "");
            GenericRuleReasoner reasoner = new GenericRuleReasoner(Rule.parseRules((String)rules));
            return reasoner.bindSchema(vocab).bind(data);
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
            return null;
        }
    }

    static Node node(String str) {
        return NodeFactory.createURI((String)("http://example/" + str));
    }

    static List<Triple> findInGraph(Graph graph, Node s, Node p, Node o) {
        return graph.find(s, p, o).toList();
    }

    static <X> void printDiff(PrintStream out, List<X> expected, List<X> actual) {
        if (actual.size() < 10) {
            out.println("Actual:");
            if (actual.isEmpty()) {
                out.println("  Empty");
            } else {
                actual.forEach(t -> out.println("  " + t));
            }
        }
        Pair diff = ListUtils.listDiffBoth(expected, actual);
        out.println("  Diff expected\\actual");
        ((List)diff.getLeft()).forEach(t -> out.println("    Expected, not actual: " + t));
        out.println("  Diff actual\\expected:");
        ((List)diff.getRight()).forEach(t -> out.println("   Actual, not expected: " + t));
        out.println();
    }

    static List<Triple> print(PrintStream out, List<Triple> x) {
        return LibTestRDFS.print(out, "  ", x);
    }

    static List<Triple> print(PrintStream out, String leader, List<Triple> x) {
        List list = Iter.toList(x.iterator());
        if (list.isEmpty()) {
            out.println(leader + "<empty>");
        } else {
            list.stream().forEach(triple -> out.println(leader + triple));
        }
        return list;
    }
}

