/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web;

import org.apache.jena.atlas.web.AcceptList;
import org.apache.jena.atlas.web.MediaType;
import org.junit.Assert;
import org.junit.Test;

public class TestContentNegotiation {
    static final String ctFirefox = "text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5";
    static final String ctIE_6 = "image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, application/x-shockwave-flash, application/vnd.ms-excel, application/msword, */*";
    static final String ctApplicationXML = "application/xml";
    static final String ctApplicationRDFXML = "application/rdf+xml";
    static final String ctApplicationStar = "application/*";
    static final String ctTextPlain = "text/plain";
    static final String ctTextXML = "text/xml";
    static final String ctTextStar = "text/*";
    static final String ctStarStar = "*/*";
    private static final String offerResultSet = "application/sparql-results+xml, application/sparql-results+json, text/csv , text/tab-separated-values, text/plain";
    private static final String offerRDF = "text/turtle, application/turtle, application/x-turtle,  application/n-triples, text/plain, application/rdf+xml, application/rdf+json";

    @Test
    public void simpleNeg1() {
        this.testMatch(ctTextPlain, ctTextPlain, ctTextPlain);
    }

    @Test
    public void simpleNeg2() {
        this.testMatch(ctApplicationXML, ctTextPlain, null);
    }

    @Test
    public void simpleNeg3() {
        this.testMatch(ctTextStar, ctTextPlain, ctTextPlain);
    }

    @Test
    public void listNeg1() {
        this.testMatch("text/xml,text/*", ctTextXML, ctTextXML);
    }

    @Test
    public void listNeg2() {
        this.testMatch("text/xml,text/*", "text/plain,text/xml", ctTextXML);
    }

    @Test
    public void listNeg3() {
        this.testMatch("text/xml,text/*", ctTextPlain, ctTextPlain);
    }

    @Test
    public void qualNeg1() {
        this.testMatch("text/xml;q=0.5,text/plain", ctTextPlain, ctTextPlain);
    }

    @Test
    public void qualNeg2() {
        this.testMatch("text/turtle,application/rdf+xml;q=0.5", "application/rdf+xml,text/turtle", "text/turtle");
    }

    @Test
    public void qualNeg3() {
        this.testMatch("text/turtle,application/rdf+xml;q=0.5", "text/turtle,application/rdf+xml", "text/turtle");
    }

    @Test
    public void qualNeg4() {
        this.testMatch("application/rdf+xml;q=0.5,text/turtle", "text/turtle,application/rdf+xml", "text/turtle");
    }

    @Test
    public void qualNeg5() {
        this.testMatch("application/rdf+xml;q=0.5,text/turtle", ",application/rdf+xml,text/turtle", "text/turtle");
    }

    @Test
    public void connegResultSet_01() {
        this.testMatch("application/sparql-results+json , application/sparql-results+xml;q=0.9 , application/rdf+xml , application/turtle;q=0.9 , */*;q=0.1", offerResultSet, "application/sparql-results+json");
    }

    @Test
    public void connegResultSet_02() {
        this.testMatch("application/sparql-results+xml;q=0.9, */*;q=0.1", offerResultSet, "application/sparql-results+xml");
    }

    @Test
    public void connegResultSet_03() {
        this.testMatch("application/sparql-results+json;q=0.9, */*;q=0.1", offerResultSet, "application/sparql-results+json");
    }

    @Test
    public void conneg_01() {
        this.testMatch("application/sparql-results+json , application/sparql-results+xml;q=0.9 , text/turtle, application/rdf+xml;q=0.9 , */*;q=0.1", offerRDF, "text/turtle");
    }

    @Test
    public void connegRDF_01() {
        this.testMatch("application/rdf+xml , text/turtle;q=0.9 , */*;q=0.1", offerRDF, ctApplicationRDFXML);
    }

    @Test
    public void connegRDF_02() {
        this.testMatch("application/turtle;q=0.9 , application/rdf+xml , */*;q=0.1", offerRDF, ctApplicationRDFXML);
    }

    private void testMatch(String header, String offer, String result) {
        AcceptList list1 = new AcceptList(header);
        AcceptList list2 = new AcceptList(offer);
        MediaType matchItem = AcceptList.match((AcceptList)list1, (AcceptList)list2);
        if (result == null) {
            Assert.assertNull((String)("Match not null: from " + this.q(header) + " :: " + this.q(offer)), (Object)matchItem);
            return;
        }
        Assert.assertNotNull((String)("Match is null: expected " + this.q(result)), (Object)matchItem);
        Assert.assertEquals((String)"Match different", (Object)result, (Object)matchItem.toHeaderString());
    }

    private String q(Object obj) {
        if (obj == null) {
            return "<null>";
        }
        return "'" + obj.toString() + "'";
    }
}

