/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.junit.sparql.tests;

import org.apache.jena.arq.junit.LibTestSetup;
import org.apache.jena.arq.junit.manifest.ManifestEntry;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFParserBuilder;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.sparql.vocabulary.TestManifestX;
import org.apache.jena.sparql.vocabulary.VocabTestQuery;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

class SparqlTestLib {
    SparqlTestLib() {
    }

    static RDFParserBuilder parser(String sourceURI) {
        return RDFParser.create().source(sourceURI).errorHandler(ErrorHandlerFactory.errorHandlerNoWarnings);
    }

    static void setupFailure(String msg) {
        throw new RuntimeException(msg);
    }

    static void testFailure(String msg) {
        throw new AssertionError((Object)msg);
    }

    private static String queryFile(ManifestEntry entry) {
        Resource r = entry.getAction();
        if (r.hasProperty(VocabTestQuery.query)) {
            return LibTestSetup.getLiteralOrURI(r, VocabTestQuery.query);
        }
        if (r.isAnon()) {
            return "[]";
        }
        return r.getURI();
    }

    static Query queryFromEntry(ManifestEntry entry) {
        return SparqlTestLib.queryFromEntry(entry, null);
    }

    static Query queryFromEntry(ManifestEntry entry, Syntax syntax) {
        if (SparqlTestLib.queryFile(entry) == null) {
            SparqlTestLib.setupFailure("Query test file is null");
            return null;
        }
        Syntax syn = syntax;
        if (syn == null) {
            syn = SparqlTestLib.querySyntax(entry, null);
        }
        Query query = QueryFactory.read((String)SparqlTestLib.queryFile(entry), null, (Syntax)syn);
        return query;
    }

    private static Syntax querySyntax(ManifestEntry entry, Syntax def) {
        Syntax synFileName;
        Resource r = entry.getAction();
        if (r.hasProperty(TestManifestX.querySyntax)) {
            Syntax x = Syntax.make((String)r.getProperty(TestManifestX.querySyntax).getResource().getURI());
            return x;
        }
        Resource q = r.getPropertyResourceValue(VocabTestQuery.query);
        if (q == null) {
            q = entry.getAction();
        }
        if (q == null) {
            System.err.println("No query");
            return Syntax.syntaxSPARQL_11;
        }
        String uri = q.getURI();
        if (uri != null && (synFileName = SparqlTestLib.guessFileSyntax(uri)) != null) {
            return synFileName;
        }
        return def;
    }

    protected static Syntax guessFileSyntax(String filename) {
        return Syntax.guessFileSyntax((String)filename);
    }

    static UpdateRequest updateFromEntry(ManifestEntry entry) {
        return SparqlTestLib.updateFromEntry(entry, null);
    }

    static UpdateRequest updateFromEntry(ManifestEntry entry, Syntax syntax) {
        if (SparqlTestLib.queryFile(entry) == null) {
            SparqlTestLib.setupFailure("Query test file is null");
            return null;
        }
        String fn = SparqlTestLib.queryFile(entry);
        Syntax syn = syntax != null ? syntax : SparqlTestLib.guessFileSyntax(fn);
        UpdateRequest request = UpdateFactory.read((String)fn, (Syntax)syn);
        return request;
    }
}

