/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.tdb2.lib.TupleLib;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.TableBase;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.tupletable.TupleIndex;

public class TripleTable
extends TableBase {
    public TripleTable(TupleIndex[] indexes, NodeTable nodeTable) {
        super(3, indexes, nodeTable);
    }

    public void add(Triple triple) {
        this.add(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public void add(Node s, Node p, Node o) {
        this.table.addRow(s, p, o);
    }

    public void delete(Triple triple) {
        this.delete(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public void delete(Node s, Node p, Node o) {
        this.table.deleteRow(s, p, o);
    }

    public Iterator<Triple> find(Node s, Node p, Node o) {
        Iterator<Tuple<NodeId>> iter = this.table.findAsNodeIds(s, p, o);
        if (iter == null) {
            return Iter.nullIterator();
        }
        Iterator<Triple> iter2 = TupleLib.convertToTriples(this.table.getNodeTable(), iter);
        return iter2;
    }

    public void clearTriples() {
        this.table.clear();
    }
}

