/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.main;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb2.loader.base.BulkStartFinish;
import org.apache.jena.tdb2.loader.base.MonitorOutput;
import org.apache.jena.tdb2.loader.main.DataBlock;
import org.apache.jena.tdb2.loader.main.PrefixHandler;

public class DataBatcher
implements StreamRDFCounting,
BulkStartFinish {
    private List<Triple> triples = null;
    private List<Quad> quads = null;
    private long countTriples;
    private long countQuads;
    private final MonitorOutput output;
    private final PrefixHandler prefixHandler;
    private Consumer<DataBlock> batchDestination;

    public DataBatcher(Consumer<DataBlock> batchDestination, PrefixHandler prefixHandler, MonitorOutput output) {
        this(batchDestination, prefixHandler, 500000, 10, output);
    }

    public DataBatcher(Consumer<DataBlock> batchDestination, PrefixHandler prefixHandler, int tickPoint, int superTick, MonitorOutput output) {
        this.batchDestination = batchDestination;
        this.output = output;
        this.prefixHandler = prefixHandler;
    }

    @Override
    public void startBulk() {
    }

    @Override
    public void finishBulk() {
        DataBlock lastData = null;
        if (!this.isEmpty(this.triples) || !this.isEmpty(this.quads)) {
            lastData = new DataBlock(this.triples, this.quads);
            this.dispatch(lastData);
            this.triples = null;
            this.quads = null;
        }
        this.dispatch(DataBlock.END);
    }

    private <X> boolean isEmpty(List<X> list) {
        return list == null || list.isEmpty();
    }

    public void start() {
    }

    public void finish() {
    }

    public long count() {
        return this.countTriples() + this.countQuads();
    }

    public long countTriples() {
        return this.countTriples;
    }

    public long countQuads() {
        return this.countQuads;
    }

    public void triple(Triple triple) {
        if (this.triples == null) {
            this.triples = this.allocChunkTriples();
        }
        this.triples.add(triple);
        ++this.countTriples;
        this.maybeDispatch();
    }

    public void quad(Quad quad) {
        if (quad.isTriple() || quad.isDefaultGraph()) {
            this.triple(quad.asTriple());
            return;
        }
        if (this.quads == null) {
            this.quads = this.allocChunkQuads();
        }
        this.quads.add(quad);
        ++this.countQuads;
        this.maybeDispatch();
    }

    private void maybeDispatch() {
        long x = 0L;
        if (this.triples != null) {
            x += (long)this.triples.size();
        }
        if (this.quads != null) {
            x += (long)this.quads.size();
        }
        if (x <= 100000L) {
            return;
        }
        DataBlock block = new DataBlock(this.triples, this.quads);
        this.dispatch(block);
        this.triples = null;
        this.quads = null;
    }

    private void dispatch(DataBlock datablock) {
        this.batchDestination.accept(datablock);
    }

    public void base(String base) {
    }

    public void prefix(String prefix, String iri) {
        if (this.prefixHandler != null) {
            this.prefixHandler.accept(prefix, iri);
        }
    }

    private List<Triple> allocChunkTriples() {
        return new ArrayList<Triple>(100000);
    }

    private List<Quad> allocChunkQuads() {
        return new ArrayList<Quad>(100000);
    }
}

