/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.io.nquad;

import com.apicatalog.jsonld.uri.UriUtils;
import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.RdfLiteral;
import com.apicatalog.rdf.RdfNQuad;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfValue;
import com.apicatalog.rdf.io.RdfReader;
import com.apicatalog.rdf.io.error.RdfReaderException;
import com.apicatalog.rdf.io.nquad.Tokenizer;
import java.io.Reader;
import java.util.Arrays;

public final class NQuadsReader
implements RdfReader {
    private final Tokenizer tokenizer;
    private RdfDataset dataset;

    public NQuadsReader(Reader reader) {
        this.tokenizer = new Tokenizer(reader);
        this.dataset = null;
    }

    @Override
    public RdfDataset readDataset() throws RdfReaderException {
        if (this.dataset != null) {
            return this.dataset;
        }
        this.dataset = Rdf.createDataset();
        while (this.tokenizer.hasNext()) {
            if (this.tokenizer.accept(Tokenizer.TokenType.END_OF_LINE) || this.tokenizer.accept(Tokenizer.TokenType.WHITE_SPACE) || this.tokenizer.accept(Tokenizer.TokenType.COMMENT)) continue;
            this.dataset.add(this.reaStatement());
        }
        return this.dataset;
    }

    private RdfNQuad reaStatement() throws RdfReaderException {
        RdfResource subject = this.readResource("Subject");
        this.skipWhitespace(0);
        RdfResource predicate = this.readResource("Predicate");
        this.skipWhitespace(0);
        RdfValue object = this.readObject();
        RdfResource graphName = null;
        this.skipWhitespace(0);
        if (Tokenizer.TokenType.IRI_REF == this.tokenizer.token().getType()) {
            String graphNameIri = this.tokenizer.token().getValue();
            NQuadsReader.assertAbsoluteIri(graphNameIri, "Graph name");
            graphName = Rdf.createIRI(graphNameIri);
            this.tokenizer.next();
            this.skipWhitespace(0);
        }
        if (Tokenizer.TokenType.BLANK_NODE_LABEL == this.tokenizer.token().getType()) {
            graphName = Rdf.createBlankNode("_:".concat(this.tokenizer.token().getValue()));
            this.tokenizer.next();
            this.skipWhitespace(0);
        }
        if (Tokenizer.TokenType.END_OF_STATEMENT != this.tokenizer.token().getType()) {
            NQuadsReader.unexpected(this.tokenizer.token(), Tokenizer.TokenType.END_OF_STATEMENT);
        }
        this.tokenizer.next();
        this.skipWhitespace(0);
        if (Tokenizer.TokenType.COMMENT == this.tokenizer.token().getType()) {
            this.tokenizer.next();
        } else if (Tokenizer.TokenType.END_OF_LINE != this.tokenizer.token().getType() && Tokenizer.TokenType.END_OF_INPUT != this.tokenizer.token().getType()) {
            NQuadsReader.unexpected(this.tokenizer.token(), Tokenizer.TokenType.END_OF_LINE, Tokenizer.TokenType.END_OF_INPUT);
            this.tokenizer.next();
        }
        return Rdf.createNQuad(subject, predicate, object, graphName);
    }

    private RdfResource readResource(String name) throws RdfReaderException {
        Tokenizer.Token token = this.tokenizer.token();
        if (Tokenizer.TokenType.IRI_REF == token.getType()) {
            this.tokenizer.next();
            String iri = token.getValue();
            NQuadsReader.assertAbsoluteIri(iri, name);
            return Rdf.createIRI(iri);
        }
        if (Tokenizer.TokenType.BLANK_NODE_LABEL == token.getType()) {
            this.tokenizer.next();
            return Rdf.createBlankNode("_:".concat(token.getValue()));
        }
        return (RdfResource)NQuadsReader.unexpected(token, new Tokenizer.TokenType[0]);
    }

    private RdfValue readObject() throws RdfReaderException {
        Tokenizer.Token token = this.tokenizer.token();
        if (Tokenizer.TokenType.IRI_REF == token.getType()) {
            this.tokenizer.next();
            String iri = token.getValue();
            NQuadsReader.assertAbsoluteIri(iri, "Object");
            return Rdf.createIRI(iri);
        }
        if (Tokenizer.TokenType.BLANK_NODE_LABEL == token.getType()) {
            this.tokenizer.next();
            return Rdf.createBlankNode("_:".concat(token.getValue()));
        }
        return this.readLiteral();
    }

    private RdfLiteral readLiteral() throws RdfReaderException {
        Tokenizer.Token value = this.tokenizer.token();
        if (Tokenizer.TokenType.STRING_LITERAL_QUOTE != value.getType()) {
            NQuadsReader.unexpected(value, new Tokenizer.TokenType[0]);
        }
        this.tokenizer.next();
        this.skipWhitespace(0);
        if (Tokenizer.TokenType.LANGTAG == this.tokenizer.token().getType()) {
            String langTag = this.tokenizer.token().getValue();
            this.tokenizer.next();
            return Rdf.createLangString(value.getValue(), langTag);
        }
        if (Tokenizer.TokenType.LITERAL_DATA_TYPE == this.tokenizer.token().getType()) {
            this.tokenizer.next();
            this.skipWhitespace(0);
            Tokenizer.Token attr = this.tokenizer.token();
            if (Tokenizer.TokenType.IRI_REF == attr.getType()) {
                this.tokenizer.next();
                String iri = attr.getValue();
                NQuadsReader.assertAbsoluteIri(iri, "DataType");
                return Rdf.createTypedString(value.getValue(), iri);
            }
            NQuadsReader.unexpected(attr, new Tokenizer.TokenType[0]);
        }
        return Rdf.createString(value.getValue());
    }

    private static final <T> T unexpected(Tokenizer.Token token, Tokenizer.TokenType ... types) throws RdfReaderException {
        throw new RdfReaderException("Unexpected token " + token.getType() + (String)(token.getValue() != null ? "[" + token.getValue() + "]" : "") + ". Expected one of " + Arrays.toString((Object[])types) + ".");
    }

    private void skipWhitespace(int min) throws RdfReaderException {
        int count = 0;
        while (this.tokenizer.accept(Tokenizer.TokenType.WHITE_SPACE)) {
            ++count;
        }
        if (count < min) {
            NQuadsReader.unexpected(this.tokenizer.token(), new Tokenizer.TokenType[0]);
        }
    }

    private static final void assertAbsoluteIri(String iri, String what) throws RdfReaderException {
        if (UriUtils.isNotAbsoluteUri(iri)) {
            throw new RdfReaderException(what + " must be an absolute IRI [" + iri + "]. ");
        }
    }
}

