/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.filelog.rotate;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.rdfpatch.PatchException;
import org.apache.jena.rdfpatch.filelog.rotate.FileRotateException;
import org.apache.jena.rdfpatch.filelog.rotate.Filename;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMgr {
    static Logger LOG = LoggerFactory.getLogger(FileMgr.class);
    private static final int IDX_TRIES = 1000;
    static Pattern patternIncremental = Pattern.compile("(.*)(\\.)(\\d+)");
    static final String INC_SEP = ".";
    static Comparator<Filename> cmpNumericModifier = (x, y) -> {
        long vx = FileMgr.indexFromFilename(x);
        long vy = FileMgr.indexFromFilename(y);
        return Long.compare(vx, vy);
    };

    public static Path freshFilename(Path directory, String filename) {
        return FileMgr.freshFilename(directory, filename, 0, INC_SEP, "%d");
    }

    public static Path freshFilename(Path directory, String filename, int startingFrom, String sep, String format) {
        for (int idx = startingFrom; idx < 1000 + startingFrom; ++idx) {
            String fn = idx == 0 ? filename : FileMgr.basename(filename, idx, sep, format);
            Path p = directory.resolve(fn);
            if (Files.exists(p, new LinkOption[0])) continue;
            return p;
        }
        FmtLog.warn((Logger)LOG, (String)("Failed to find a unique file extension name for " + filename), (Object[])new Object[0]);
        return null;
    }

    public static <X> List<Filename> scan(Path directory, String namebase, Pattern pattern) {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            FmtLog.error((Logger)LOG, (String)"Not a directory: %s", (Object[])new Object[]{directory});
            throw new FileRotateException("Not a directory: " + directory.toString());
        }
        ArrayList<Filename> indexes = new ArrayList<Filename>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, namebase + "*");){
            for (Path f : stream) {
                Filename filename = FileMgr.fromPath(directory, f, pattern);
                if (filename == null) continue;
                indexes.add(filename);
            }
        }
        catch (IOException ex) {
            FmtLog.warn((Logger)LOG, (String)"Can't inspect directory: (%s, %s)", (Object[])new Object[]{directory, namebase});
            throw new PatchException(ex);
        }
        return indexes;
    }

    public static List<Filename> scanIncludeBase(Path directory, String filename, Pattern pattern) {
        List<Filename> filenames = FileMgr.scan(directory, filename, pattern);
        if (Files.exists(directory.resolve(filename), new LinkOption[0])) {
            Filename fn = new Filename(directory, filename, null, null, null);
            filenames.add(fn);
        }
        return filenames;
    }

    private static Filename fromPath(Path directory, Path filepath, Pattern pattern) {
        filepath = directory.resolve(filepath).getFileName();
        directory = directory.resolve(filepath).getParent();
        return FileMgr.fromPath(directory, filepath.getFileName().toString(), pattern);
    }

    public static Filename fromPath(Path directory, String fn, Pattern pattern) {
        Matcher matcher = pattern.matcher(fn);
        if (!matcher.matches()) {
            return null;
        }
        if (matcher.groupCount() != 3) {
            FmtLog.info((Logger)LOG, (String)("Match but wrong groups: " + fn), (Object[])new Object[0]);
            return null;
        }
        String basename = matcher.group(1);
        String separator = matcher.group(2);
        String modifier = matcher.group(3);
        String compression = null;
        if (matcher.groupCount() >= 4) {
            compression = matcher.group(4);
        }
        return new Filename(directory, basename, separator, modifier, compression);
    }

    public static void shiftFiles(Path directory, String filename) {
        FileMgr.shiftFiles(directory, filename, 1, "%d");
    }

    static long indexFromFilename(Filename filename) {
        if (filename.isBasename()) {
            return 0L;
        }
        return Long.parseLong(filename.modifier);
    }

    public static List<Filename> scanForIncrement(Path directory, String filename) {
        return FileMgr.scanIncludeBase(directory, filename, patternIncremental);
    }

    public static void shiftFiles(Path directory, String filename, int increment, String format) {
        if (increment <= 0) {
            throw new IllegalArgumentException("Increment must be positive: got " + increment);
        }
        List<Filename> files = FileMgr.scanForIncrement(directory, filename);
        Collections.sort(files, cmpNumericModifier.reversed());
        for (Filename fn : files) {
            Path src = directory.resolve(fn.asFilenameString());
            if (!Files.exists(src, new LinkOption[0])) {
                throw new FileRotateException("Does not exist: " + src);
            }
            if (fn.isBasename()) continue;
            Integer.parseInt(fn.modifier);
        }
        for (Filename fn : files) {
            Path src1 = fn.absolute();
            Path src = directory.resolve(fn.asFilenameString());
            if (!Files.exists(src, new LinkOption[0])) {
                throw new FileRotateException("Does not exist: " + src);
            }
            long idx = fn.isBasename() ? 0L : (long)Integer.parseInt(fn.modifier);
            long idx2 = idx + (long)increment;
            String target = String.format("%s%s" + format, fn.basename, INC_SEP, idx2);
            Path dst = directory.resolve(target);
            try {
                Files.move(src, dst, new CopyOption[0]);
            }
            catch (IOException e) {
                IO.exception((IOException)e);
            }
        }
    }

    static String basename(String base, long idx, String sep, String modFormat) {
        return String.format("%s%s" + modFormat, base, sep, idx);
    }
}

