/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.storage.StoragePrefixes;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionException;
import org.apache.jena.dboe.transaction.txn.TransactionalSystem;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.system.PrefixEntry;
import org.apache.jena.riot.system.PrefixLib;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;

public class StoragePrefixesTDB
implements StoragePrefixes {
    static final RecordFactory factory = new RecordFactory(24, 0);
    private TransactionalSystem txnSystem;
    private NodeTupleTable prefixTable;

    public StoragePrefixesTDB(TransactionalSystem txnSystem, NodeTupleTable prefixTable) {
        this.txnSystem = txnSystem;
        this.prefixTable = prefixTable;
    }

    public NodeTupleTable getNodeTupleTable() {
        return this.prefixTable;
    }

    public String get(Node graphNode, String prefix) {
        this.requireTxn();
        graphNode = PrefixLib.canonicalGraphName((Node)graphNode);
        Node p = NodeFactory.createLiteral((String)prefix);
        Iterator<Tuple<Node>> iter = this.prefixTable.find(graphNode, p, null);
        if (!iter.hasNext()) {
            return null;
        }
        Node x = (Node)iter.next().get(2);
        Iter.close(iter);
        return x.getURI();
    }

    public Iterator<PrefixEntry> get(Node graphNode) {
        this.requireTxn();
        graphNode = PrefixLib.canonicalGraphName((Node)graphNode);
        Iterator<Tuple<Node>> iter = this.prefixTable.find(graphNode, null, null);
        return Iter.iter(iter).map(t -> PrefixEntry.create((String)((Node)t.get(1)).getLiteralLexicalForm(), (String)((Node)t.get(2)).getURI()));
    }

    public Iterator<Node> listGraphNodes() {
        this.requireTxn();
        Iterator<Tuple<Node>> iter = this.prefixTable.find(new Node[]{null, null, null});
        return Iter.iter(iter).map(t -> (Node)t.get(0)).distinct();
    }

    public void add(Node graphNode, String prefix, String iriStr) {
        this.ensureWriteTxn();
        this.add_ext(graphNode, prefix, iriStr);
    }

    public void add_ext(Node graphNode, String prefix, String iriStr) {
        graphNode = PrefixLib.canonicalGraphName((Node)graphNode);
        Node p = NodeFactory.createLiteral((String)prefix);
        Node u = NodeFactory.createURI((String)iriStr);
        this.remove_ext(graphNode, p, Node.ANY);
        this.prefixTable.addRow(graphNode, p, u);
    }

    public void delete(Node graphNode, String prefix) {
        Node p = NodeFactory.createLiteral((String)prefix);
        this.remove(graphNode, p, null);
    }

    public void deleteAll(Node graphNode) {
        this.remove(graphNode, null, null);
    }

    private void remove(Node g, Node p, Node u) {
        this.ensureWriteTxn();
        this.remove_ext(g, p, u);
    }

    private void remove_ext(Node g, Node p, Node u) {
        g = PrefixLib.canonicalGraphName((Node)g);
        Iterator<Tuple<Node>> iter = this.prefixTable.find(g, p, u);
        List list = Iter.toList(iter);
        for (Tuple tuple : list) {
            this.prefixTable.deleteRow((Node)tuple.get(0), (Node)tuple.get(1), (Node)tuple.get(2));
        }
    }

    public boolean isEmpty() {
        this.requireTxn();
        return this.prefixTable.isEmpty();
    }

    public int size() {
        this.requireTxn();
        return (int)this.prefixTable.size();
    }

    private void requireTxn() {
    }

    private void ensureWriteTxn() {
        Transaction txn = this.txnSystem.getThreadTransaction();
        if (txn == null) {
            throw new TransactionException("Not in a transaction");
        }
        txn.ensureWriteTxn();
    }
}

