/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.ResultBinding;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.UpdateExec;
import org.apache.jena.sparql.exec.UpdateExecAdapter;
import org.apache.jena.sparql.exec.UpdateExecBuilder;
import org.apache.jena.sparql.exec.UpdateExecutionBuilderAdapter;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateExecution;
import org.apache.jena.update.UpdateExecutionBuilder;
import org.apache.jena.update.UpdateRequest;

public class UpdateExecBuilderAdapter
implements UpdateExecBuilder {
    protected UpdateExecutionBuilder builder;

    protected UpdateExecBuilderAdapter(UpdateExecutionBuilder delegate) {
        this.builder = delegate;
    }

    public static UpdateExecBuilder adapt(UpdateExecutionBuilder builder) {
        Objects.requireNonNull(builder);
        UpdateExecBuilder result = builder instanceof UpdateExecutionBuilderAdapter ? ((UpdateExecutionBuilderAdapter)builder).getExecBuilder() : new UpdateExecBuilderAdapter(builder);
        return result;
    }

    public UpdateExecutionBuilder getExecBuilder() {
        return this.builder;
    }

    @Override
    public UpdateExecBuilder update(UpdateRequest updateRequest) {
        this.builder = this.builder.update(updateRequest);
        return this;
    }

    @Override
    public UpdateExecBuilder update(Update update) {
        this.builder = this.builder.update(update);
        return this;
    }

    @Override
    public UpdateExecBuilder update(String updateRequestString) {
        this.builder = this.builder.update(updateRequestString);
        return this;
    }

    @Override
    public UpdateExecBuilder set(Symbol symbol, Object value) {
        this.builder = this.builder.set(symbol, value);
        return this;
    }

    @Override
    public UpdateExecBuilder set(Symbol symbol, boolean value) {
        this.builder = this.builder.set(symbol, value);
        return this;
    }

    @Override
    public UpdateExecBuilder context(Context context2) {
        this.builder = this.builder.context(context2);
        return this;
    }

    @Override
    public UpdateExecBuilder substitution(Binding binding) {
        this.builder = this.builder.substitution(new ResultBinding(null, binding));
        return this;
    }

    @Override
    public UpdateExecBuilder substitution(String varName, Node value) {
        this.builder = this.builder.substitution(varName, ModelUtils.convertGraphNodeToRDFNode(value));
        return this;
    }

    @Override
    public UpdateExecBuilder substitution(Var var, Node value) {
        this.builder = this.builder.substitution(var.getName(), ModelUtils.convertGraphNodeToRDFNode(value));
        return this;
    }

    @Override
    public UpdateExec build() {
        UpdateExecution updateExec = this.builder.build();
        UpdateExec result = UpdateExecAdapter.adapt(updateExec);
        return result;
    }
}

