/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.engine.main.QC;

public class QueryIterLateral
extends QueryIterRepeatApply {
    private final Op lateralOp;
    private final boolean isUnit;

    public QueryIterLateral(QueryIterator input, Op lateralOp, ExecutionContext execCxt) {
        super(input, execCxt);
        this.lateralOp = lateralOp;
        this.isUnit = this.isJoinIdentity(lateralOp);
    }

    private boolean isJoinIdentity(Op op) {
        if (!(op instanceof OpTable)) {
            return false;
        }
        OpTable table = (OpTable)this.lateralOp;
        return table.isJoinIdentity();
    }

    @Override
    protected QueryIterator nextStage(Binding binding) {
        if (this.isUnit) {
            return QueryIterSingleton.create(binding, super.getExecContext());
        }
        Op op = Substitute.substitute(this.lateralOp, binding);
        return QC.execute(op, binding, super.getExecContext());
    }
}

