/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.github.jsonldjava.core.JsonLdApi;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.writer.JenaRDF2JSONLD10;
import org.apache.jena.riot.writer.WriterDatasetRIOTBase;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.util.SplitIRI;
import org.apache.jena.vocabulary.RDF;

@Deprecated
public class JsonLD10Writer
extends WriterDatasetRIOTBase {
    private static final String SYMBOLS_NS = "http://jena.apache.org/riot/jsonld#";
    public static final Symbol JSONLD_CONTEXT = JsonLD10Writer.createSymbol("JSONLD_CONTEXT");
    public static final Symbol JSONLD_CONTEXT_SUBSTITUTION = JsonLD10Writer.createSymbol("JSONLD_CONTEXT_SUBSTITUTION");
    public static final Symbol JSONLD_FRAME = JsonLD10Writer.createSymbol("JSONLD_FRAME");
    public static final Symbol JSONLD_OPTIONS = JsonLD10Writer.createSymbol("JSONLD_OPTIONS");
    public static final Symbol JSONLD_ADD_ALL_PREFIXES_TO_CONTEXT = JsonLD10Writer.createSymbol("JSONLD_ADD_ALL_PREFIXES_TO_CONTEXT");
    private final RDFFormat format;

    private static Symbol createSymbol(String localName) {
        return Symbol.create(SYMBOLS_NS + localName);
    }

    public JsonLD10Writer(RDFFormat syntaxForm) {
        this.format = syntaxForm;
    }

    @Override
    public Lang getLang() {
        return this.format.getLang();
    }

    @Override
    public void write(Writer out, DatasetGraph dataset, PrefixMap prefixMap, String baseURI, Context context2) {
        this.serialize(out, dataset, prefixMap, baseURI, context2);
    }

    @Override
    public void write(OutputStream out, DatasetGraph dataset, PrefixMap prefixMap, String baseURI, Context context2) {
        OutputStreamWriter w = new OutputStreamWriter(out, Chars.charsetUTF8);
        this.write(w, dataset, prefixMap, baseURI, context2);
        IO.flush((Writer)w);
    }

    private RDFFormat.JSONLDVariant getVariant() {
        return (RDFFormat.JSONLDVariant)this.format.getVariant();
    }

    private static JsonLdOptions getJsonLdOptions(String baseURI, Context jenaContext) {
        JsonLdOptions opts = null;
        if (jenaContext != null) {
            opts = (JsonLdOptions)jenaContext.get(JSONLD_OPTIONS);
        }
        if (opts == null) {
            opts = JsonLD10Writer.defaultJsonLdOptions(baseURI);
        }
        return opts;
    }

    private static JsonLdOptions defaultJsonLdOptions(String baseURI) {
        JsonLdOptions opts = new JsonLdOptions(baseURI);
        opts.useNamespaces = true;
        opts.setUseNativeTypes(Boolean.valueOf(true));
        opts.setCompactArrays(Boolean.valueOf(true));
        return opts;
    }

    private void serialize(Writer writer, DatasetGraph dataset, PrefixMap prefixMap, String baseURI, Context jenaContext) {
        try {
            Object obj = JsonLD10Writer.toJsonLDJavaAPI(this.getVariant(), dataset, prefixMap, baseURI, jenaContext);
            if (this.getVariant().isPretty()) {
                JsonUtils.writePrettyPrint((Writer)writer, (Object)obj);
            } else {
                JsonUtils.write((Writer)writer, (Object)obj);
            }
            writer.write("\n");
        }
        catch (JsonGenerationException | JsonMappingException | JsonLdError e2) {
            throw new RiotException(e2);
        }
        catch (IOException e3) {
            IO.exception((IOException)e3);
        }
    }

    public static Object toJsonLDJavaAPI(RDFFormat.JSONLDVariant variant, DatasetGraph dataset, PrefixMap prefixMap, String baseURI, Context jenaContext) throws JsonLdError, JsonParseException, IOException {
        JsonLdOptions opts = JsonLD10Writer.getJsonLdOptions(baseURI, jenaContext);
        RDFDataset jsonldDataset = new JenaRDF2JSONLD10().parse(dataset);
        Object obj = new JsonLdApi(opts).fromRDF(jsonldDataset, true);
        if (!variant.isExpand()) {
            if (variant.isFrame()) {
                Object frame = null;
                if (jenaContext != null) {
                    frame = jenaContext.get(JSONLD_FRAME);
                }
                if (frame == null) {
                    throw new IllegalArgumentException("No frame object found in jena Context");
                }
                if (frame instanceof String) {
                    frame = JsonUtils.fromString((String)((String)frame));
                }
                obj = JsonLdProcessor.frame((Object)obj, (Object)frame, (JsonLdOptions)opts);
            } else {
                Map map;
                Object ctxReplacement;
                Object ctx = JsonLD10Writer.getJsonldContext(dataset, prefixMap, jenaContext);
                if (variant.isCompact()) {
                    obj = JsonLdProcessor.compact((Object)obj, (Object)ctx, (JsonLdOptions)opts);
                } else if (variant.isFlatten()) {
                    obj = JsonLdProcessor.flatten((Object)obj, (Object)ctx, (JsonLdOptions)opts);
                } else {
                    throw new IllegalArgumentException("Unexpected " + RDFFormat.JSONLDVariant.class.getName() + ": " + variant);
                }
                if (jenaContext != null && (ctxReplacement = jenaContext.get(JSONLD_CONTEXT_SUBSTITUTION)) != null && obj instanceof Map && (map = (Map)obj).containsKey("@context")) {
                    map.put("@context", JsonUtils.fromString((String)ctxReplacement.toString()));
                }
            }
        }
        return obj;
    }

    private static Object getJsonldContext(DatasetGraph dataset, PrefixMap prefixMap, Context jenaContext) throws JsonParseException, IOException {
        Object ctx = null;
        boolean isCtxDefined = false;
        if (jenaContext != null && jenaContext.isDefined(JSONLD_CONTEXT)) {
            isCtxDefined = true;
            Object o = jenaContext.get(JSONLD_CONTEXT);
            if (o != null) {
                if (o instanceof String) {
                    String jsonString = (String)o;
                    ctx = JsonUtils.fromString((String)jsonString);
                } else {
                    ctx = o;
                }
            }
        }
        if (!isCtxDefined) {
            ctx = JsonLD10Writer.createJsonldContext(dataset.getDefaultGraph(), prefixMap, JsonLD10Writer.addAllPrefixesToContextFlag(jenaContext));
        }
        return ctx;
    }

    static Object createJsonldContext(Graph g) {
        return JsonLD10Writer.createJsonldContext(g, PrefixMapFactory.create(g.getPrefixMapping()), true);
    }

    private static Object createJsonldContext(Graph g, PrefixMap prefixMap, boolean addAllPrefixesToContext) {
        LinkedHashMap<String, Object> ctx = new LinkedHashMap<String, Object>();
        JsonLD10Writer.addProperties(ctx, g);
        JsonLD10Writer.addPrefixes(ctx, g, prefixMap, addAllPrefixesToContext);
        return ctx;
    }

    static void addProperties(Map<String, Object> ctx, Graph g) {
        Consumer<Triple> x = item -> {
            Node p = item.getPredicate();
            Node o = item.getObject();
            if (p.equals((Object)RDF.type.asNode())) {
                return;
            }
            String uriStr = SplitIRI.localname((String)p.getURI());
            if (!ctx.containsKey(uriStr)) {
                if (o.isBlank() || o.isURI()) {
                    LinkedHashMap<String, String> x2 = new LinkedHashMap<String, String>();
                    x2.put("@id", p.getURI());
                    x2.put("@type", "@id");
                    ctx.put(uriStr, x2);
                } else if (o.isLiteral()) {
                    String literalDatatypeURI = o.getLiteralDatatypeURI();
                    if (literalDatatypeURI != null) {
                        LinkedHashMap<String, String> x2 = new LinkedHashMap<String, String>();
                        x2.put("@id", p.getURI());
                        if (!Util.isLangString((Node)o) && !Util.isSimpleString((Node)o)) {
                            x2.put("@type", literalDatatypeURI);
                        }
                        ctx.put(uriStr, x2);
                    } else {
                        ctx.put(uriStr, p.getURI());
                    }
                }
            }
        };
        g.find(Triple.ANY).forEach(x);
    }

    private static void addPrefixes(final Map<String, Object> ctx, Graph g, final PrefixMap prefixMap, boolean addAllPrefixesToContext) {
        if (prefixMap != null) {
            final Map<String, String> mapping = prefixMap.getMapping();
            if (addAllPrefixesToContext) {
                for (Map.Entry<String, String> e2 : mapping.entrySet()) {
                    JsonLD10Writer.addOnePrefix(ctx, e2.getKey(), e2.getValue());
                }
            } else {
                Consumer<Triple> x = new Consumer<Triple>(){

                    @Override
                    public void accept(Triple item) {
                        Node node = item.getSubject();
                        if (node.isURI()) {
                            this.addPrefix2Ctx(node.getURI());
                        }
                        node = item.getPredicate();
                        this.addPrefix2Ctx(node.getURI());
                        node = item.getObject();
                        if (node.isURI()) {
                            this.addPrefix2Ctx(node.getURI());
                        }
                    }

                    private void addPrefix2Ctx(String resUri) {
                        Pair<String, String> pair = prefixMap.abbrev(resUri);
                        if (pair != null) {
                            String prefix = (String)pair.getLeft();
                            JsonLD10Writer.addOnePrefix(ctx, prefix, ((String)mapping.get(prefix)).toString());
                        }
                    }
                };
                g.find(Triple.ANY).forEachRemaining((Consumer)x);
            }
        }
    }

    static void addOnePrefix(Map<String, Object> ctx, String prefix, String value) {
        if (!prefix.isEmpty()) {
            ctx.put(prefix, value);
        } else {
            ctx.put("@vocab", value);
        }
    }

    private static boolean addAllPrefixesToContextFlag(Context jenaContext) {
        Object o;
        if (jenaContext != null && (o = jenaContext.get(JSONLD_ADD_ALL_PREFIXES_TO_CONTEXT)) != null) {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            throw new IllegalArgumentException("Value attached to JSONLD_ADD_ALL_PREFIXES_TO_CONTEXT shoud be a Boolean");
        }
        return true;
    }
}

