/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jclouds.profitbricks.compute.function;

import static com.google.common.base.Preconditions.checkNotNull;

import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.profitbricks.domain.Storage;

import com.google.common.base.Function;

public class StorageToVolume implements Function<Storage, Volume> {

   @Override
   public Volume apply(Storage storage) {
      checkNotNull(storage, "Null storage");

      String device = "";
      if (storage.deviceNumber() != null)
         device = storage.deviceNumber().toString();

      return new VolumeBuilder()
              .id(storage.id())
              .size(storage.size())
              .bootDevice(storage.bootDevice())
              .device(device)
              .durable(true)
              .type(Volume.Type.LOCAL)
              .build();

   }
}
