/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jclouds.sqs.parse;

import static org.testng.Assert.assertEquals;

import java.io.InputStream;
import java.net.URI;

import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;
import org.jclouds.sqs.xml.RegexQueueHandler;
import org.testng.annotations.Test;

// NOTE:without testName, this will not call @Before* and fail w/NPE during
// surefire
@Test(groups = "unit", testName = "CreateQueueResponseTest")
public class CreateQueueResponseTest {

   public void test() {
      InputStream is = getClass().getResourceAsStream("/create_queue.xml");

      URI expected = expected();

      RegexQueueHandler handler = new RegexQueueHandler(new ReturnStringIf2xx());
      URI result = handler.apply(HttpResponse.builder().statusCode(200).payload(is).build());

      assertEquals(result.toString(), expected.toString());

   }

   public URI expected() {
      return URI.create("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11");
   }
}
