/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jclouds.route53.parse;

import static org.testng.Assert.assertEquals;

import java.io.InputStream;

import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.route53.xml.InvalidChangeBatchHandler;
import org.testng.annotations.Test;

import com.google.common.collect.ImmutableList;

// NOTE:without testName, this will not call @Before* and fail w/NPE during
// surefire
@Test(groups = "unit", testName = "InvalidChangeBatchResponseTest")
public class InvalidChangeBatchResponseTest extends BaseHandlerTest {

   public void test() {
      InputStream is = getClass().getResourceAsStream("/invalid_change_batch.xml");

      InvalidChangeBatchHandler handler = injector.getInstance(InvalidChangeBatchHandler.class);
      ImmutableList<String> result = factory.create(handler).parse(is);

      assertEquals(result, ImmutableList.of(
            "Tried to create resource record set duplicate.example.com. type A, but it already exists",
            "Tried to delete resource record set noexist.example.com. type A, but it was not found"));
   }
}
