/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jclouds.openstack.nova.v2_0.domain.zonescoped;

import static com.google.common.base.Objects.equal;
import static com.google.common.base.Preconditions.checkNotNull;

import java.util.Set;

import com.google.common.base.Objects;
import com.google.common.base.MoreObjects.ToStringHelper;
import com.google.common.collect.ImmutableSet;

/**
 * @deprecated This package has been replaced with {@link org.jclouds.openstack.nova.v2_0.domain.regionscoped}.
 *             Please use {@link org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionSecurityGroupNameAndPorts RegionSecurityGroupNameAndPorts}
 *             instead. To be removed in jclouds 2.0.
 */
@Deprecated
public class RegionSecurityGroupNameAndPorts extends RegionAndName {
   protected final Set<Integer> ports;

   public RegionSecurityGroupNameAndPorts(String regionId, String name, Iterable<Integer> ports) {
      super(regionId, name);
      this.ports = ImmutableSet.<Integer> copyOf(checkNotNull(ports, "ports"));
   }

   public Set<Integer> getPorts() {
      return ports;
   }

   @Override
   public boolean equals(Object o) {
      if (this == o)
         return true;
      if (o == null || getClass() != o.getClass())
         return false;
      RegionSecurityGroupNameAndPorts that = RegionSecurityGroupNameAndPorts.class.cast(o);
      return super.equals(that) && equal(this.ports, that.ports);
   }

   @Override
   public int hashCode() {
      return Objects.hashCode(super.hashCode(), ports);
   }

   @Override
   public ToStringHelper string() {
      return super.string().add("ports", ports);
   }
}
