/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.instrument.manager.AbstractInstrumentSample;
import org.apache.excalibur.instrument.manager.AbstractValueInstrumentSample;
import org.apache.excalibur.instrument.manager.CounterInstrumentListener;
import org.apache.excalibur.instrument.manager.CounterInstrumentSample;
import org.apache.excalibur.instrument.manager.InstrumentDescriptorLocal;
import org.apache.excalibur.instrument.manager.InstrumentDescriptorLocalImpl;
import org.apache.excalibur.instrument.manager.InstrumentListener;
import org.apache.excalibur.instrument.manager.InstrumentSample;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptorLocal;
import org.apache.excalibur.instrument.manager.InstrumentSampleFactory;
import org.apache.excalibur.instrument.manager.InstrumentableProxy;
import org.apache.excalibur.instrument.manager.ValueInstrumentListener;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentSampleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class InstrumentProxy
extends AbstractLogEnabled
implements org.apache.excalibur.instrument.InstrumentProxy,
Configurable {
    private InstrumentableProxy m_instrumentableProxy;
    private boolean m_configured;
    private boolean m_registered;
    private String m_name;
    private String m_description;
    private InstrumentDescriptorLocal m_descriptor;
    private int m_type;
    private InstrumentListener[] m_listeners;
    private HashMap m_samples;
    private InstrumentSample[] m_sampleArray;
    private InstrumentSampleDescriptorLocal[] m_sampleDescriptorArray;
    private Logger m_valueLogger;
    private int m_lastValue;
    private int m_stateVersion;

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.m_valueLogger = logger.getChildLogger("values");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure(Configuration configuration) throws ConfigurationException {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            this.m_description = configuration.getAttribute("description", this.m_description);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Configuring Instrument: " + this.m_name + " as \"" + this.m_description + '\"');
            }
            this.m_configured = true;
            Configuration[] sampleConfs = configuration.getChildren("sample");
            int i = 0;
            while (i < sampleConfs.length) {
                Configuration sampleConf = sampleConfs[i];
                int sampleType = InstrumentSampleUtils.resolveInstrumentSampleType((String)sampleConf.getAttribute("type"));
                long sampleInterval = sampleConf.getAttributeAsLong("interval");
                int sampleSize = sampleConf.getAttributeAsInteger("size", 1);
                String sampleName = InstrumentSampleUtils.generateFullInstrumentSampleName((String)this.m_name, (int)sampleType, (long)sampleInterval, (int)sampleSize);
                String defaultDescription = InstrumentSampleUtils.generateInstrumentSampleName((int)sampleType, (long)sampleInterval, (int)sampleSize);
                String sampleDescription = sampleConf.getAttribute("description", defaultDescription);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Configuring InstrumentSample: " + sampleName + " as \"" + sampleDescription + '\"');
                }
                AbstractInstrumentSample instrumentSample = (AbstractInstrumentSample)InstrumentSampleFactory.getInstrumentSample(this, sampleType, sampleName, sampleInterval, sampleSize, sampleDescription, 0L);
                instrumentSample.enableLogging(this.getLogger());
                instrumentSample.setConfigured();
                this.addInstrumentSample(instrumentSample);
                ++i;
            }
            return;
        }
    }

    public boolean isActive() {
        boolean bl = false;
        if (this.m_listeners != null) {
            bl = true;
        }
        return bl;
    }

    public void increment(int count) {
        if (this.m_type != 1) {
            throw new IllegalStateException("The proxy is not configured to handle CounterInstruments.");
        }
        InstrumentListener[] listeners = this.m_listeners;
        if (listeners != null) {
            if (this.m_valueLogger.isDebugEnabled()) {
                this.m_valueLogger.debug("increment() called for Instrument, " + this.m_name);
            }
            long time = System.currentTimeMillis();
            int i = 0;
            while (i < listeners.length) {
                CounterInstrumentListener listener = (CounterInstrumentListener)listeners[i];
                listener.increment(this.getName(), count, time);
                ++i;
            }
        }
    }

    public void setValue(int value) {
        if (this.m_type != 2) {
            throw new IllegalStateException("The proxy is not configured to handle ValueInstruments.");
        }
        this.m_lastValue = value;
        InstrumentListener[] listeners = this.m_listeners;
        if (listeners != null) {
            if (this.m_valueLogger.isDebugEnabled()) {
                this.m_valueLogger.debug("setValue( " + value + " ) called for Instrument, " + this.m_name);
            }
            long time = System.currentTimeMillis();
            int i = 0;
            while (i < listeners.length) {
                ValueInstrumentListener listener = (ValueInstrumentListener)listeners[i];
                listener.setValue(this.getName(), value, time);
                ++i;
            }
        }
    }

    InstrumentableProxy getInstrumentableProxy() {
        return this.m_instrumentableProxy;
    }

    boolean isConfigured() {
        return this.m_configured;
    }

    boolean isRegistered() {
        return this.m_registered;
    }

    void setRegistered() {
        this.m_registered = true;
    }

    String getName() {
        return this.m_name;
    }

    void setDescription(String description) {
        this.m_description = description;
    }

    String getDescription() {
        return this.m_description;
    }

    InstrumentDescriptorLocal getDescriptor() {
        return this.m_descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setType(int type) {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            if (this.m_type != 0) {
                throw new IllegalStateException("Type already set.");
            }
            switch (type) {
                case 1: 
                case 2: {
                    this.m_type = type;
                    break;
                }
                default: {
                    throw new IllegalStateException(type + " is not a valid type.");
                }
            }
            return;
        }
    }

    int getType() {
        return this.m_type;
    }

    void addCounterInstrumentListener(CounterInstrumentListener listener) {
        if (this.m_type != 1) {
            throw new IllegalStateException("The proxy is not configured to handle CounterInstruments.");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("A CounterInstrumentListener was added to Instrument, " + this.m_name + " : " + listener.getClass().getName());
        }
        this.addInstrumentListener(listener);
    }

    void removeCounterInstrumentListener(CounterInstrumentListener listener) {
        if (this.m_type != 1) {
            throw new IllegalStateException("The proxy is not configured to handle CounterInstruments.");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("A CounterInstrumentListener was removed from Instrument, " + this.m_name + " : " + listener.getClass().getName());
        }
        this.removeInstrumentListener(listener);
    }

    void addValueInstrumentListener(ValueInstrumentListener listener) {
        if (this.m_type != 2) {
            throw new IllegalStateException("The proxy is not configured to handle ValueInstruments.");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("A ValueInstrumentListener was added to Instrument, " + this.m_name + " : " + listener.getClass().getName());
        }
        this.addInstrumentListener(listener);
        long time = System.currentTimeMillis();
        listener.setValue(this.getName(), this.m_lastValue, time);
    }

    void removeValueInstrumentListener(ValueInstrumentListener listener) {
        if (this.m_type != 2) {
            throw new IllegalStateException("The proxy is not configured to handle ValueInstruments.");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("A ValueInstrumentListener was removed from Instrument, " + this.m_name + " : " + listener.getClass().getName());
        }
        this.removeInstrumentListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void addInstrumentSample(InstrumentSample instrumentSample) {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            block10: {
                block9: {
                    if (this.m_type != 0) break block9;
                    this.setType(instrumentSample.getInstrumentType());
                    break block10;
                }
                if (this.m_type != instrumentSample.getInstrumentType()) {
                    throw new IllegalStateException("The sample '" + instrumentSample.getName() + "' had its type set to " + InstrumentProxy.getTypeName(this.m_type) + " by another sample.  This sample has a type of " + InstrumentProxy.getTypeName(instrumentSample.getInstrumentType()) + " and is not compatible.");
                }
            }
            String sampleName = instrumentSample.getName();
            if (this.m_samples.get(sampleName) != null) {
                throw new IllegalStateException("More than one sample with the same name, '" + sampleName + "', can not be configured.");
            }
            this.m_samples.put(sampleName, instrumentSample);
            this.m_sampleArray = null;
            this.m_sampleDescriptorArray = null;
            switch (this.m_type) {
                case 1: {
                    this.addCounterInstrumentListener((CounterInstrumentSample)instrumentSample);
                    break;
                }
                case 2: {
                    this.addValueInstrumentListener((AbstractValueInstrumentSample)instrumentSample);
                    break;
                }
                default: {
                    throw new IllegalStateException("Don't know how to deal with the type: " + this.m_type);
                }
            }
        }
        this.stateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeInstrumentSample(InstrumentSample instrumentSample) {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            switch (this.m_type) {
                case 1: {
                    this.removeCounterInstrumentListener((CounterInstrumentSample)instrumentSample);
                    break;
                }
                case 2: {
                    this.removeValueInstrumentListener((AbstractValueInstrumentSample)instrumentSample);
                    break;
                }
                default: {
                    throw new IllegalStateException("Don't know how to deal with the type: " + this.m_type);
                }
            }
            this.m_samples.remove(instrumentSample.getName());
            this.m_sampleArray = null;
            this.m_sampleDescriptorArray = null;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl17 : MonitorExitStatement: MONITOREXIT : var2_2
            this.stateChanged();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    InstrumentSample getInstrumentSample(String InstrumentSampleName) {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            return (InstrumentSample)this.m_samples.get(InstrumentSampleName);
        }
    }

    InstrumentSample[] getInstrumentSamples() {
        InstrumentSample[] samples = this.m_sampleArray;
        if (samples == null) {
            samples = this.updateInstrumentSampleArray();
        }
        return samples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    InstrumentSample createInstrumentSample(String sampleDescription, long sampleInterval, int sampleSize, long sampleLease, int sampleType) {
        this.getLogger().debug("Create new sample for " + this.m_name + ": interval=" + sampleInterval + ", size=" + sampleSize + ", lease=" + sampleLease + ", type=" + InstrumentSampleUtils.getInstrumentSampleTypeName((int)sampleType));
        long now = System.currentTimeMillis();
        String sampleName = InstrumentSampleUtils.generateFullInstrumentSampleName((String)this.m_name, (int)sampleType, (long)sampleInterval, (int)sampleSize);
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            InstrumentSample instrumentSample;
            block4: {
                block3: {
                    instrumentSample = this.getInstrumentSample(sampleName);
                    if (instrumentSample == null) break block3;
                    instrumentSample.extendLease(sampleLease);
                    break block4;
                }
                instrumentSample = InstrumentSampleFactory.getInstrumentSample(this, sampleType, sampleName, sampleInterval, sampleSize, sampleDescription, sampleLease);
                instrumentSample.enableLogging(this.getLogger());
                this.addInstrumentSample(instrumentSample);
                this.getInstrumentableProxy().getInstrumentManager().registerLeasedInstrumentSample(instrumentSample);
            }
            return instrumentSample;
        }
    }

    InstrumentSampleDescriptorLocal[] getInstrumentSampleDescriptors() {
        InstrumentSampleDescriptorLocal[] descriptors = this.m_sampleDescriptorArray;
        if (descriptors == null) {
            descriptors = this.updateInstrumentSampleDescriptorArray();
        }
        return descriptors;
    }

    int getStateVersion() {
        return this.m_stateVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void addInstrumentListener(InstrumentListener listener) {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            InstrumentListener[] newListeners;
            block4: {
                InstrumentListener[] oldListeners;
                block3: {
                    oldListeners = this.m_listeners;
                    if (oldListeners != null) break block3;
                    newListeners = new InstrumentListener[]{listener};
                    break block4;
                }
                newListeners = new InstrumentListener[oldListeners.length + 1];
                System.arraycopy(oldListeners, 0, newListeners, 0, oldListeners.length);
                newListeners[oldListeners.length] = listener;
            }
            this.m_listeners = newListeners;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void removeInstrumentListener(InstrumentListener listener) {
        var2_2 = this;
        synchronized (var2_2) {
            block10: {
                block8: {
                    block9: {
                        block7: {
                            oldListeners = this.m_listeners;
                            if (oldListeners != null) break block7;
                            newListeners = null;
                            break block8;
                        }
                        if (oldListeners.length != 1) break block9;
                        newListeners = oldListeners[0] == listener ? null : oldListeners;
                        break block8;
                    }
                    pos = -1;
                    i = 0;
                    if (true) ** GOTO lbl27
                }
lbl19:
                // 4 sources

                while (true) {
                    this.m_listeners = newListeners;
                    return;
                }
                do {
                    if (oldListeners[i] == listener) {
                        pos = i;
                        break;
                    }
                    ++i;
lbl27:
                    // 2 sources

                } while (i < oldListeners.length);
                if (pos >= 0) break block10;
                newListeners = oldListeners;
                ** GOTO lbl19
            }
            newListeners = new InstrumentListener[oldListeners.length - 1];
            if (pos > 0) {
                System.arraycopy(oldListeners, 0, newListeners, 0, pos);
            }
            if (pos >= oldListeners.length - 1) ** GOTO lbl19
            System.arraycopy(oldListeners, pos + 1, newListeners, pos, oldListeners.length - 1 - pos);
            ** continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final InstrumentSample[] updateInstrumentSampleArray() {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            this.m_sampleArray = new InstrumentSample[this.m_samples.size()];
            this.m_samples.values().toArray(this.m_sampleArray);
            Arrays.sort(this.m_sampleArray, new Comparator(this){
                final /* synthetic */ InstrumentProxy this$0;

                public final int compare(Object o1, Object o2) {
                    return ((InstrumentSample)o1).getDescription().compareTo(((InstrumentSample)o2).getDescription());
                }

                public final boolean equals(Object obj) {
                    return false;
                }
                {
                    this.this$0 = instrumentProxy;
                }
            });
            return this.m_sampleArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final InstrumentSampleDescriptorLocal[] updateInstrumentSampleDescriptorArray() {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            if (this.m_sampleArray == null) {
                this.updateInstrumentSampleArray();
            }
            this.m_sampleDescriptorArray = new InstrumentSampleDescriptorLocal[this.m_sampleArray.length];
            int i = 0;
            while (i < this.m_sampleArray.length) {
                this.m_sampleDescriptorArray[i] = this.m_sampleArray[i].getDescriptor();
                ++i;
            }
            return this.m_sampleDescriptorArray;
        }
    }

    Configuration saveState() {
        boolean empty = true;
        DefaultConfiguration state = new DefaultConfiguration("instrument", "-");
        state.setAttribute("name", this.m_name);
        InstrumentSample[] samples = this.getInstrumentSamples();
        int i = 0;
        while (i < samples.length) {
            Configuration childState = samples[i].saveState();
            if (childState != null) {
                state.addChild(childState);
                empty = false;
            }
            ++i;
        }
        if (empty) {
            state = null;
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void loadState(Configuration state) throws ConfigurationException {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            Configuration[] instrumentSampleConfs = state.getChildren("sample");
            int i = 0;
            while (true) {
                int sampleSize;
                long sampleInterval;
                if (i >= instrumentSampleConfs.length) {
                    // MONITOREXIT @DISABLED, blocks:[1, 3, 6] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.stateChanged();
                    return;
                }
                Configuration instrumentSampleConf = instrumentSampleConfs[i];
                int sampleType = InstrumentSampleUtils.resolveInstrumentSampleType((String)instrumentSampleConf.getAttribute("type"));
                String fullSampleName = InstrumentSampleUtils.generateFullInstrumentSampleName((String)this.m_name, (int)sampleType, (long)(sampleInterval = instrumentSampleConf.getAttributeAsLong("interval")), (int)(sampleSize = instrumentSampleConf.getAttributeAsInteger("size", 1)));
                InstrumentSample sample = this.getInstrumentSample(fullSampleName);
                if (sample == null) {
                    long leaseExpirationTime = instrumentSampleConf.getAttributeAsLong("lease-expiration", 0L);
                    if (leaseExpirationTime > 0L) {
                        String sampleName = InstrumentSampleUtils.generateInstrumentSampleName((int)sampleType, (long)sampleInterval, (int)sampleSize);
                        String sampleDescription = instrumentSampleConf.getAttribute("description", sampleName);
                        AbstractInstrumentSample instrumentSample = (AbstractInstrumentSample)InstrumentSampleFactory.getInstrumentSample(this, sampleType, fullSampleName, sampleInterval, sampleSize, sampleDescription, 0L);
                        instrumentSample.enableLogging(this.getLogger());
                        instrumentSample.loadState(instrumentSampleConf);
                        this.addInstrumentSample(instrumentSample);
                    } else {
                        this.getLogger().warn("InstrumentSample entry ignored while loading state because the sample does not exist: " + fullSampleName);
                    }
                } else {
                    sample.loadState(instrumentSampleConf);
                }
                ++i;
            }
        }
    }

    protected void stateChanged() {
        ++this.m_stateVersion;
        this.m_instrumentableProxy.stateChanged();
    }

    public static String getTypeName(int type) {
        switch (type) {
            case 0: {
                return "none";
            }
            case 1: {
                return "counter";
            }
            case 2: {
                return "value";
            }
        }
        throw new IllegalArgumentException(type + " is not a known Instrument type.");
    }

    private final /* synthetic */ void this() {
        this.m_samples = new HashMap();
    }

    InstrumentProxy(InstrumentableProxy instrumentableProxy, String name, String description) {
        this.this();
        this.m_instrumentableProxy = instrumentableProxy;
        this.m_name = name;
        this.m_description = description;
        this.m_descriptor = new InstrumentDescriptorLocalImpl(this);
    }
}

