/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager;

import org.apache.excalibur.instrument.manager.CounterInstrumentListener;
import org.apache.excalibur.instrument.manager.InstrumentDescriptorLocal;
import org.apache.excalibur.instrument.manager.InstrumentProxy;
import org.apache.excalibur.instrument.manager.InstrumentSample;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptorLocal;
import org.apache.excalibur.instrument.manager.ValueInstrumentListener;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.interfaces.NoSuchInstrumentSampleException;

public class InstrumentDescriptorLocalImpl
implements InstrumentDescriptorLocal {
    private InstrumentProxy m_instrumentProxy;

    public boolean isConfigured() {
        return this.m_instrumentProxy.isConfigured();
    }

    public boolean isRegistered() {
        return this.m_instrumentProxy.isRegistered();
    }

    public String getName() {
        return this.m_instrumentProxy.getName();
    }

    public String getDescription() {
        return this.m_instrumentProxy.getDescription();
    }

    public int getType() {
        return this.m_instrumentProxy.getType();
    }

    public InstrumentSampleDescriptor getInstrumentSampleDescriptor(String instrumentSampleName) throws NoSuchInstrumentSampleException {
        return this.getInstrumentSampleDescriptorLocal(instrumentSampleName);
    }

    public InstrumentSampleDescriptor createInstrumentSample(String sampleDescription, long sampleInterval, int sampleSize, long sampleLease, int sampleType) {
        return this.createInstrumentSampleLocal(sampleDescription, sampleInterval, sampleSize, sampleLease, sampleType);
    }

    public InstrumentSampleDescriptor[] getInstrumentSampleDescriptors() {
        return this.getInstrumentSampleDescriptorLocals();
    }

    public int getStateVersion() {
        return this.m_instrumentProxy.getStateVersion();
    }

    public void addCounterInstrumentListener(CounterInstrumentListener listener) {
        this.m_instrumentProxy.addCounterInstrumentListener(listener);
    }

    public void removeCounterInstrumentListener(CounterInstrumentListener listener) {
        this.m_instrumentProxy.removeCounterInstrumentListener(listener);
    }

    public void addValueInstrumentListener(ValueInstrumentListener listener) {
        this.m_instrumentProxy.addValueInstrumentListener(listener);
    }

    public void removeValueInstrumentListener(ValueInstrumentListener listener) {
        this.m_instrumentProxy.removeValueInstrumentListener(listener);
    }

    public InstrumentSampleDescriptorLocal getInstrumentSampleDescriptorLocal(String instrumentSampleName) throws NoSuchInstrumentSampleException {
        InstrumentSample instrumentSample = this.m_instrumentProxy.getInstrumentSample(instrumentSampleName);
        if (instrumentSample == null) {
            throw new NoSuchInstrumentSampleException("No instrument sample can be found using name: " + instrumentSampleName);
        }
        return instrumentSample.getDescriptor();
    }

    public InstrumentSampleDescriptorLocal createInstrumentSampleLocal(String sampleDescription, long sampleInterval, int sampleSize, long sampleLease, int sampleType) {
        InstrumentSample sample = this.m_instrumentProxy.createInstrumentSample(sampleDescription, sampleInterval, sampleSize, sampleLease, sampleType);
        return sample.getDescriptor();
    }

    public InstrumentSampleDescriptorLocal[] getInstrumentSampleDescriptorLocals() {
        return this.m_instrumentProxy.getInstrumentSampleDescriptors();
    }

    InstrumentDescriptorLocalImpl(InstrumentProxy instrumentProxy) {
        this.m_instrumentProxy = instrumentProxy;
    }
}

