/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.packagemanager;

import java.io.File;
import org.apache.avalon.excalibur.extension.Extension;

public final class OptionalPackage {
    private final File m_file;
    private final Extension[] m_available;
    private final Extension[] m_required;

    public static final File[] toFiles(OptionalPackage[] packages) {
        File[] results = new File[packages.length];
        int i = 0;
        while (i < packages.length) {
            results[i] = packages[i].getFile();
            ++i;
        }
        return results;
    }

    public OptionalPackage(File file, Extension[] available, Extension[] required) {
        if (null == file) {
            throw new NullPointerException("file");
        }
        if (null == available) {
            throw new NullPointerException("available");
        }
        if (null == required) {
            throw new NullPointerException("required");
        }
        this.m_file = file;
        this.m_available = available;
        this.m_required = required;
    }

    public File getFile() {
        return this.m_file;
    }

    public Extension[] getRequiredExtensions() {
        return this.m_required;
    }

    public Extension[] getAvailableExtensions() {
        return this.m_available;
    }

    public boolean isCompatible(Extension extension) {
        int i = 0;
        while (i < this.m_available.length) {
            if (this.m_available[i].isCompatibleWith(extension)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("OptionalPackage[");
        sb.append(this.m_file);
        sb.append(", Available[");
        int i = 0;
        while (i < this.m_available.length) {
            if (0 != i) {
                sb.append(" ");
            }
            sb.append(this.m_available[i].getExtensionName());
            ++i;
        }
        sb.append("], Required[");
        int i2 = 0;
        while (i2 < this.m_required.length) {
            if (0 != i2) {
                sb.append(" ");
            }
            sb.append(this.m_required[i2].getExtensionName());
            ++i2;
        }
        sb.append("] ]");
        return sb.toString();
    }
}

