/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.launcher;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Policy;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.phoenix.launcher.FreeNEasyPolicy;
import org.apache.avalon.phoenix.launcher.LauncherUtils;

public final class Main {
    private static final String MAIN_CLASS = "org.apache.avalon.phoenix.frontends.CLIMain";
    private static Object c_frontend;

    public static final void main(String[] args) throws Exception {
        int exitCode = Main.startup(args, new HashMap(), true);
        System.exit(exitCode);
    }

    protected static final int startup(String[] args, Map data, boolean blocking) {
        int exitCode;
        try {
            Policy.setPolicy(new FreeNEasyPolicy());
            URL[] urls = LauncherUtils.getEngineClassPath();
            URLClassLoader classLoader = new URLClassLoader(urls);
            data.put("common.classloader", ClassLoader.getSystemClassLoader());
            data.put("container.classloader", classLoader);
            data.put("phoenix.home", new File(LauncherUtils.findPhoenixHome()));
            Thread.currentThread().setContextClassLoader(classLoader);
            String ttlcache = System.getProperty("networkaddress.cache.ttl");
            if (ttlcache != null) {
                Security.setProperty("networkaddress.cache.ttl", ttlcache);
            }
            Class<?> clazz = classLoader.loadClass(MAIN_CLASS);
            Class[] paramTypes = new Class[]{args.getClass(), Map.class, Boolean.TYPE};
            Method method = clazz.getMethod("main", paramTypes);
            c_frontend = clazz.newInstance();
            Integer integer = (Integer)method.invoke(c_frontend, args, data, new Boolean(blocking));
            exitCode = integer;
        }
        catch (Exception e) {
            e.printStackTrace();
            exitCode = 1;
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void shutdown() {
        if (null == c_frontend) {
            return;
        }
        try {
            Class<?> clazz = c_frontend.getClass();
            Method method = clazz.getMethod("shutdown", new Class[0]);
            method.invoke(c_frontend, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            c_frontend = null;
        }
    }
}

