/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.rmi;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import mx4j.MBeanDescriptionAdapter;

public class RMIAdaptorMBeanDescription
extends MBeanDescriptionAdapter {
    public String getConstructorDescription(Constructor ctor) {
        String name = ctor.getName();
        return super.getConstructorDescription(ctor);
    }

    public String getConstructorParameterName(Constructor ctor, int index) {
        return super.getConstructorParameterName(ctor, index);
    }

    public String getConstructorParameterDescription(Constructor ctor, int index) {
        return super.getConstructorParameterDescription(ctor, index);
    }

    public String getAttributeDescription(String attribute) {
        if (attribute.equals("Running")) {
            return "The running status of this adaptor";
        }
        if (attribute.equals("Protocol")) {
            return "The underlying protocol used by this adaptor";
        }
        if (attribute.equals("JNDIName")) {
            return "The JNDI name under which a stub for the RMIConnector is registered";
        }
        if (attribute.equals("JNDIProperties")) {
            return "The JNDI properties";
        }
        if (attribute.equals("NamingProperties")) {
            return "The JNDI properties";
        }
        if (attribute.equals("HostName")) {
            return "The name of the host where this adaptor is running";
        }
        if (attribute.equals("HostAddress")) {
            return "The IP address of the host where this adaptor is running";
        }
        return super.getAttributeDescription(attribute);
    }

    public String getOperationDescription(Method operation) {
        String name = operation.getName();
        if (name.equals("start")) {
            return "Starts the adaptor";
        }
        if (name.equals("stop")) {
            return "Stops the adaptor";
        }
        if (name.equals("putJNDIProperty")) {
            return "Puts a property-value pair to be used by JNDI to create the InitialContext";
        }
        if (name.equals("putNamingProperty")) {
            return "Puts a property-value pair to be used by JNDI to create the InitialContext";
        }
        if (name.equals("clearJNDIProperties")) {
            return "Clears all previously inserted JNDI properties";
        }
        if (name.equals("clearNamingProperties")) {
            return "Clears all previously inserted JNDI properties";
        }
        return super.getOperationDescription(operation);
    }

    public String getOperationParameterName(Method method, int index) {
        String name = method.getName();
        if (name.equals("putJNDIProperty")) {
            switch (index) {
                case 0: {
                    return "property";
                }
                case 1: {
                    return "value";
                }
            }
        }
        if (name.equals("putNamingProperty")) {
            switch (index) {
                case 0: {
                    return "property";
                }
                case 1: {
                    return "value";
                }
            }
        }
        return super.getOperationParameterName(method, index);
    }

    public String getOperationParameterDescription(Method method, int index) {
        String name = method.getName();
        if (name.equals("putJNDIProperty")) {
            switch (index) {
                case 0: {
                    return "The property name";
                }
                case 1: {
                    return "The property value";
                }
            }
        }
        if (name.equals("putNamingProperty")) {
            switch (index) {
                case 0: {
                    return "The property name";
                }
                case 1: {
                    return "The property value";
                }
            }
        }
        return super.getOperationParameterDescription(method, index);
    }
}

