/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.configkit;

import java.io.IOException;
import java.io.InputStream;
import org.realityforge.configkit.EntityInfo;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ConfigKitEntityResolver
implements EntityResolver {
    private final EntityInfo[] m_infos;
    private final ClassLoader m_classLoader;

    ConfigKitEntityResolver(EntityInfo[] infos, ClassLoader classLoader) {
        if (null == infos) {
            throw new NullPointerException("infos");
        }
        this.m_infos = infos;
        this.m_classLoader = classLoader;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        int i = 0;
        while (i < this.m_infos.length) {
            EntityInfo info = this.m_infos[i];
            if (publicId != null && publicId.equals(info.getPublicId()) || systemId != null && systemId.equals(info.getSystemId())) {
                String resource;
                ClassLoader classLoader = this.getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(resource = info.getResource());
                if (null == inputStream) {
                    String message = "Unable to locate resource " + resource + " for entity with publicId=" + publicId + " and systemId=" + systemId + ". " + "Looking in classloader " + classLoader + ".";
                    throw new IOException(message);
                }
                InputSource inputSource = new InputSource(inputStream);
                inputSource.setPublicId(info.getPublicId());
                if (null == info.getSystemId()) {
                    inputSource.setSystemId(resource);
                } else {
                    inputSource.setSystemId(info.getSystemId());
                }
                return inputSource;
            }
            ++i;
        }
        return null;
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = this.m_classLoader;
        if (null == classLoader) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (null == classLoader) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }
}

