/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.verifier.regexp;

import com.sun.msv.driver.textui.Debug;
import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.BinaryExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.DataOrValueExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.IDContextProvider;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.NamespaceNameClass;
import com.sun.msv.grammar.NotNameClass;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.grammar.relax.NoneType;
import com.sun.msv.grammar.util.ExpressionPrinter;
import com.sun.msv.util.DatatypeRef;
import com.sun.msv.util.StartTagInfo;
import com.sun.msv.util.StringRef;
import com.sun.msv.verifier.Acceptor;
import com.sun.msv.verifier.regexp.AnyElementToken;
import com.sun.msv.verifier.regexp.AttributeRecoveryToken;
import com.sun.msv.verifier.regexp.AttributeToken;
import com.sun.msv.verifier.regexp.CombinedChildContentExpCreator;
import com.sun.msv.verifier.regexp.OptimizationTag;
import com.sun.msv.verifier.regexp.REDocumentDeclaration;
import com.sun.msv.verifier.regexp.StringCareLevelCalculator;
import com.sun.msv.verifier.regexp.StringRecoveryToken;
import com.sun.msv.verifier.regexp.StringToken;
import com.sun.msv.verifier.regexp.Token;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

public abstract class ExpressionAcceptor
implements Acceptor {
    private Expression expression;
    protected final REDocumentDeclaration docDecl;
    protected final boolean ignoreUndeclaredAttributes;

    public Expression getExpression() {
        return this.expression;
    }

    public ExpressionAcceptor(REDocumentDeclaration rEDocumentDeclaration, Expression expression, boolean bl) {
        this.docDecl = rEDocumentDeclaration;
        this.expression = expression;
        this.ignoreUndeclaredAttributes = bl;
    }

    public Acceptor createChildAcceptor(StartTagInfo startTagInfo, StringRef stringRef) {
        CombinedChildContentExpCreator combinedChildContentExpCreator = this.docDecl.cccec;
        CombinedChildContentExpCreator.ExpressionPair expressionPair = combinedChildContentExpCreator.get(this.expression, startTagInfo);
        if (expressionPair.content != Expression.nullSet) {
            if (Debug.debug) {
                System.out.println("accept start tag <" + startTagInfo.qName + ">. combined content pattern is");
                System.out.println(ExpressionPrinter.printContentModel(expressionPair.content));
                if (expressionPair.continuation != null) {
                    System.out.println("continuation is:\n" + ExpressionPrinter.printContentModel(expressionPair.continuation));
                } else {
                    System.out.println("no continuation");
                }
            }
            return this.createAcceptor(expressionPair.content, expressionPair.continuation, combinedChildContentExpCreator.getMatchedElements(), combinedChildContentExpCreator.numMatchedElements());
        }
        if (stringRef == null) {
            return null;
        }
        stringRef.str = this.diagnoseBadTagName(startTagInfo);
        if (stringRef.str == null) {
            stringRef.str = this.docDecl.localizeMessage("Diagnosis.BadTagName.Generic", startTagInfo.qName);
        }
        return this.createRecoveryAcceptors();
    }

    protected abstract Acceptor createAcceptor(Expression var1, Expression var2, ElementExp[] var3, int var4);

    public final boolean onAttribute(String string, String string2, String string3, String string4, IDContextProvider iDContextProvider, StringRef stringRef, DatatypeRef datatypeRef) {
        this.docDecl.attToken.reinit(string, string2, string3, new StringToken(this.docDecl, string4, iDContextProvider, datatypeRef));
        return this.onAttribute(this.docDecl.attToken, stringRef);
    }

    protected boolean onAttribute(AttributeToken attributeToken, StringRef stringRef) {
        Expression expression = this.docDecl.attFeeder.feed(this.expression, attributeToken, this.ignoreUndeclaredAttributes);
        if (expression != Expression.nullSet) {
            this.expression = expression;
            if (Debug.debug) {
                System.out.println("-- residual after :" + ExpressionPrinter.printContentModel(expression));
            }
            return true;
        }
        if (stringRef == null) {
            return false;
        }
        AttributeRecoveryToken attributeRecoveryToken = attributeToken.createRecoveryAttToken();
        expression = this.docDecl.attFeeder.feed(this.expression, attributeRecoveryToken, this.ignoreUndeclaredAttributes);
        if (expression == Expression.nullSet) {
            stringRef.str = this.expression == Expression.nullSet ? this.docDecl.localizeMessage("Diagnosis.ContentModelIsNullset", null) : this.docDecl.localizeMessage("Diagnosis.UndeclaredAttribute", attributeToken.qName);
            return true;
        }
        stringRef.str = this.diagnoseBadAttributeValue(attributeRecoveryToken);
        if (stringRef.str == null) {
            stringRef.str = this.docDecl.localizeMessage("Diagnosis.BadAttributeValue.Generic", attributeToken.qName);
        }
        this.expression = expression;
        return true;
    }

    public boolean onEndAttributes(StartTagInfo startTagInfo, StringRef stringRef) {
        Expression expression = this.docDecl.attPruner.prune(this.expression);
        if (expression != Expression.nullSet) {
            this.expression = expression;
            return true;
        }
        if (stringRef == null) {
            return false;
        }
        if (this.expression == Expression.nullSet) {
            stringRef.str = this.docDecl.localizeMessage("Diagnosis.ContentModelIsNullset", null);
        } else {
            stringRef.str = this.diagnoseMissingAttribute(startTagInfo);
            if (stringRef.str == null) {
                stringRef.str = this.docDecl.localizeMessage("Diagnosis.MissingAttribute.Generic", startTagInfo.qName);
            }
        }
        this.expression = this.expression.visit(this.docDecl.attRemover);
        return true;
    }

    protected boolean stepForward(Token token, StringRef stringRef) {
        Expression expression = this.docDecl.resCalc.calcResidual(this.expression, token);
        if (token.isIgnorable()) {
            expression = this.docDecl.pool.createChoice(expression, this.expression);
        }
        if (Debug.debug) {
            System.out.println("residual of stepForward(" + token + ")");
            System.out.print(ExpressionPrinter.printContentModel(this.expression));
            System.out.print("   ->   ");
            System.out.println(ExpressionPrinter.printContentModel(expression));
        }
        if (expression == Expression.nullSet) {
            if (stringRef != null && token instanceof StringToken) {
                stringRef.str = this.diagnoseUnexpectedLiteral((StringToken)token);
            }
            return false;
        }
        this.expression = expression;
        return true;
    }

    public boolean onText(String string, IDContextProvider iDContextProvider, StringRef stringRef, DatatypeRef datatypeRef) {
        return this.stepForward(new StringToken(this.docDecl, string, iDContextProvider, datatypeRef), stringRef);
    }

    public final boolean stepForwardByContinuation(Expression expression, StringRef stringRef) {
        if (expression != Expression.nullSet) {
            if (Debug.debug) {
                System.out.println("stepForwardByCont. :  " + ExpressionPrinter.printContentModel(expression));
            }
            this.expression = expression;
            return true;
        }
        if (stringRef == null) {
            return false;
        }
        return false;
    }

    public boolean isAcceptState(StringRef stringRef) {
        if (stringRef == null) {
            return this.expression.isEpsilonReducible();
        }
        if (this.expression.isEpsilonReducible()) {
            return true;
        }
        stringRef.str = this.diagnoseUncompletedContent();
        return false;
    }

    public int getStringCareLevel() {
        OptimizationTag optimizationTag = (OptimizationTag)this.expression.verifierTag;
        if (optimizationTag == null) {
            optimizationTag = new OptimizationTag();
            this.expression.verifierTag = optimizationTag;
        }
        if (optimizationTag.stringCareLevel == -1) {
            optimizationTag.stringCareLevel = StringCareLevelCalculator.calc(this.expression);
        }
        return optimizationTag.stringCareLevel;
    }

    private final Expression mergeContinuation(Expression expression, Expression expression2) {
        if (expression == null && expression2 == null) {
            return null;
        }
        if (expression == null || expression == Expression.nullSet) {
            return expression2;
        }
        if (expression2 == null || expression2 == Expression.nullSet) {
            return expression;
        }
        return this.docDecl.pool.createChoice(expression, expression2);
    }

    private final Acceptor createRecoveryAcceptors() {
        CombinedChildContentExpCreator combinedChildContentExpCreator = this.docDecl.cccec;
        CombinedChildContentExpCreator.ExpressionPair expressionPair = combinedChildContentExpCreator.get(this.expression, null, false);
        Expression expression = this.docDecl.resCalc.calcResidual(this.expression, AnyElementToken.theInstance);
        Expression expression2 = this.docDecl.pool.createChoice(this.expression, expression);
        Expression expression3 = expressionPair.content;
        if (Debug.debug) {
            System.out.println("content model of recovery acceptor:" + ExpressionPrinter.printContentModel(expression3));
            System.out.println("continuation of recovery acceptor:" + ExpressionPrinter.printSmallest(expression2));
        }
        return this.createAcceptor(expression3, expression2, null, 0);
    }

    private final String concatenateMessages(List list, boolean bl, String string, String string2) {
        String string3 = "";
        String string4 = this.docDecl.localizeMessage(string, null);
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((String)object).compareTo((String)object2);
            }
        });
        int n = 0;
        while (n < list.size()) {
            if (string3.length() != 0) {
                string3 = string3 + string4;
            }
            string3 = string3 + list.get(n);
            ++n;
        }
        if (bl) {
            string3 = string3 + this.docDecl.localizeMessage(string2, null);
        }
        return string3;
    }

    private final String concatenateMessages(Set set, boolean bl, String string, String string2) {
        return this.concatenateMessages(new Vector(set), bl, string, string2);
    }

    private final String getDiagnosisFromTypedString(DataOrValueExp dataOrValueExp, StringToken stringToken) {
        try {
            dataOrValueExp.getType().checkValid(stringToken.literal, (ValidationContext)stringToken.context);
            return null;
        }
        catch (DatatypeException datatypeException) {
            return datatypeException.getMessage();
        }
    }

    private final String diagnoseBadTagName(StartTagInfo startTagInfo) {
        CombinedChildContentExpCreator combinedChildContentExpCreator = this.docDecl.cccec;
        Expression expression = combinedChildContentExpCreator.get((Expression)this.expression, (StartTagInfo)startTagInfo, (boolean)false).content;
        if (expression == Expression.nullSet) {
            return this.docDecl.localizeMessage("Diagnosis.ElementNotAllowed", startTagInfo.qName);
        }
        if (combinedChildContentExpCreator.isComplex()) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        String string = null;
        ElementExp[] elementExpArray = combinedChildContentExpCreator.getMatchedElements();
        int n = combinedChildContentExpCreator.numMatchedElements();
        int n2 = 0;
        while (n2 < n) {
            if (elementExpArray[n2].contentModel.getExpandedExp(this.docDecl.pool) != Expression.nullSet) {
                NameClass nameClass;
                NameClass nameClass2 = elementExpArray[n2].getNameClass();
                if (nameClass2 instanceof SimpleNameClass) {
                    nameClass = (SimpleNameClass)nameClass2;
                    if (nameClass.localName.equals(startTagInfo.localName)) {
                        string = nameClass.namespaceURI;
                    }
                    hashSet.add(this.docDecl.localizeMessage("Diagnosis.SimpleNameClass", nameClass2.toString()));
                } else if (nameClass2 instanceof NamespaceNameClass) {
                    hashSet.add(this.docDecl.localizeMessage("Diagnosis.NamespaceNameClass", ((NamespaceNameClass)nameClass2).namespaceURI));
                } else if (nameClass2 instanceof NotNameClass && (nameClass = ((NotNameClass)nameClass2).child) instanceof NamespaceNameClass) {
                    hashSet.add(this.docDecl.localizeMessage("Diagnosis.NotNamespaceNameClass", ((NamespaceNameClass)nameClass).namespaceURI));
                } else {
                    bl = true;
                }
            }
            ++n2;
        }
        if (hashSet.size() == 0) {
            return null;
        }
        if (string != null) {
            if (hashSet.size() == 1) {
                return this.docDecl.localizeMessage("Diagnosis.BadTagName.WrongNamespace", startTagInfo.localName, string);
            }
            return this.docDecl.localizeMessage("Diagnosis.BadTagName.ProbablyWrongNamespace", startTagInfo.localName, string);
        }
        return this.docDecl.localizeMessage("Diagnosis.BadTagName.WrapUp", startTagInfo.qName, this.concatenateMessages(hashSet, bl, "Diagnosis.BadTagName.Separator", "Diagnosis.BadTagName.More"));
    }

    private final String diagnoseBadAttributeValue(AttributeRecoveryToken attributeRecoveryToken) {
        Expression expression = attributeRecoveryToken.getFailedExp();
        if (expression instanceof DataOrValueExp) {
            DataOrValueExp dataOrValueExp = (DataOrValueExp)((Object)expression);
            if (dataOrValueExp.getType() == NoneType.theInstance) {
                return this.docDecl.localizeMessage("Diagnosis.UndeclaredAttribute", attributeRecoveryToken.qName);
            }
            String string = this.getDiagnosisFromTypedString(dataOrValueExp, attributeRecoveryToken.value);
            if (string == null) {
                return null;
            }
            return this.docDecl.localizeMessage("Diagnosis.BadAttributeValue.DataType", attributeRecoveryToken.qName, string);
        }
        if (expression instanceof ChoiceExp) {
            HashSet<Object> hashSet = new HashSet<Object>();
            boolean bl = false;
            ChoiceExp choiceExp = (ChoiceExp)expression;
            Expression[] expressionArray = choiceExp.getChildren();
            int n = 0;
            while (n < expressionArray.length) {
                if (expressionArray[n] instanceof ValueExp) {
                    hashSet.add(((ValueExp)expressionArray[n]).value);
                } else {
                    bl = true;
                }
                ++n;
            }
            if (hashSet.size() == 0) {
                return null;
            }
            return this.docDecl.localizeMessage("Diagnosis.BadAttributeValue.WrapUp", attributeRecoveryToken.qName, this.concatenateMessages(hashSet, bl, "Diagnosis.BadAttributeValue.Separator", "Diagnosis.BadAttributeValue.More"));
        }
        return null;
    }

    private final String diagnoseMissingAttribute(StartTagInfo startTagInfo) {
        Serializable serializable;
        Expression expression = this.expression.visit(this.docDecl.attPicker);
        if (expression.isEpsilonReducible()) {
            throw new Error();
        }
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        while (expression instanceof ChoiceExp) {
            serializable = (ChoiceExp)expression;
            NameClass nameClass = ((AttributeExp)((BinaryExp)serializable).exp2).nameClass;
            if (nameClass instanceof SimpleNameClass) {
                hashSet.add(nameClass.toString());
            } else {
                bl = true;
            }
            expression = ((BinaryExp)serializable).exp1;
        }
        if (expression == Expression.nullSet) {
            return null;
        }
        if (!(expression instanceof AttributeExp)) {
            throw new Error(expression.toString());
        }
        serializable = ((AttributeExp)expression).nameClass;
        if (serializable instanceof SimpleNameClass) {
            hashSet.add(serializable.toString());
        } else {
            bl = true;
        }
        if (hashSet.size() == 0) {
            return null;
        }
        if (hashSet.size() == 1 && !bl) {
            return this.docDecl.localizeMessage("Diagnosis.MissingAttribute.Simple", startTagInfo.qName, hashSet.iterator().next());
        }
        return this.docDecl.localizeMessage("Diagnosis.MissingAttribute.WrapUp", startTagInfo.qName, this.concatenateMessages(hashSet, bl, "Diagnosis.MissingAttribute.Separator", "Diagnosis.MissingAttribute.More"));
    }

    private final String diagnoseUnexpectedLiteral(StringToken stringToken) {
        block10: {
            StringRecoveryToken stringRecoveryToken = new StringRecoveryToken(stringToken);
            Expression expression = this.docDecl.resCalc.calcResidual(this.expression, stringRecoveryToken);
            if (expression == Expression.nullSet) {
                return this.docDecl.localizeMessage("Diagnosis.StringNotAllowed", null);
            }
            this.expression = this.docDecl.pool.createChoice(this.expression, expression);
            if (stringRecoveryToken.failedExps.size() == 1) {
                DataOrValueExp dataOrValueExp = (DataOrValueExp)stringRecoveryToken.failedExps.iterator().next();
                try {
                    dataOrValueExp.getType().checkValid(stringRecoveryToken.literal, (ValidationContext)stringRecoveryToken.context);
                    if (dataOrValueExp instanceof ValueExp) {
                        ValueExp valueExp = (ValueExp)dataOrValueExp;
                        if (!valueExp.dt.sameValue(valueExp.value, valueExp.dt.createValue(stringRecoveryToken.literal, (ValidationContext)stringRecoveryToken.context))) {
                            return this.docDecl.localizeMessage("Diagnosis.BadLiteral.IncorrectValue", valueExp.value.toString());
                        }
                    }
                    break block10;
                }
                catch (DatatypeException datatypeException) {
                    if (datatypeException.getMessage() != null) {
                        return datatypeException.getMessage();
                    }
                    return this.docDecl.localizeMessage("Diagnosis.BadLiteral.Generic", null);
                }
            }
            HashSet<String> hashSet = new HashSet<String>();
            boolean bl = false;
            Iterator iterator = stringRecoveryToken.failedExps.iterator();
            while (iterator.hasNext()) {
                DataOrValueExp dataOrValueExp = (DataOrValueExp)iterator.next();
                if (dataOrValueExp instanceof ValueExp) {
                    hashSet.add(((ValueExp)dataOrValueExp).value.toString());
                    continue;
                }
                bl = true;
            }
            if (hashSet.size() == 0) {
                return null;
            }
            return this.docDecl.localizeMessage("Diagnosis.BadLiteral.WrapUp", this.concatenateMessages(hashSet, bl, "Diagnosis.BadLiteral.Separator", "Diagnosis.BadLiteral.More"));
        }
        return null;
    }

    protected String diagnoseUncompletedContent() {
        CombinedChildContentExpCreator combinedChildContentExpCreator = this.docDecl.cccec;
        combinedChildContentExpCreator.get(this.expression, null, false);
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        ElementExp[] elementExpArray = combinedChildContentExpCreator.getMatchedElements();
        int n = combinedChildContentExpCreator.numMatchedElements();
        int n2 = 0;
        while (n2 < n) {
            NameClass nameClass;
            NameClass nameClass2 = elementExpArray[n2].getNameClass();
            if (nameClass2 instanceof SimpleNameClass) {
                hashSet.add(this.docDecl.localizeMessage("Diagnosis.SimpleNameClass", nameClass2.toString()));
            } else if (nameClass2 instanceof NamespaceNameClass) {
                hashSet.add(this.docDecl.localizeMessage("Diagnosis.NamespaceNameClass", ((NamespaceNameClass)nameClass2).namespaceURI));
            } else if (nameClass2 instanceof NotNameClass && (nameClass = ((NotNameClass)nameClass2).child) instanceof NamespaceNameClass) {
                hashSet.add(this.docDecl.localizeMessage("Diagnosis.NotNamespaceNameClass", ((NamespaceNameClass)nameClass).namespaceURI));
            } else {
                bl = true;
            }
            ++n2;
        }
        if (hashSet.size() == 0) {
            return null;
        }
        return this.docDecl.localizeMessage("Diagnosis.UncompletedContent.WrapUp", null, this.concatenateMessages(hashSet, bl, "Diagnosis.UncompletedContent.Separator", "Diagnosis.UncompletedContent.More"));
    }

    public abstract Acceptor createClone();

    public abstract Object getOwnerType();

    public abstract boolean stepForward(Acceptor var1, StringRef var2);
}

