/*
 * Decompiled with CFR 0.152.
 */
package mx4j.connector;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import mx4j.connector.MalformedJMXAddressException;

public class JMXAddress
implements Serializable,
Cloneable {
    private String address;
    private transient String m_protocol;
    private transient String m_host;
    private transient int m_port;
    private transient String m_path;
    private transient HashMap m_properties;

    public JMXAddress(String address) throws MalformedJMXAddressException {
        this.parse(address);
        this.address = this.toString();
    }

    public JMXAddress(String proto, String host, int port, String path) throws MalformedJMXAddressException {
        StringBuffer buffer = new StringBuffer("jmx:");
        buffer.append(proto).append("://").append(host);
        if (port > 0) {
            buffer.append(":").append(port);
        }
        buffer.append("/").append(path);
        this.parse(buffer.toString());
        this.address = this.toString();
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    private void setProtocol(String protocol) {
        this.m_protocol = protocol;
    }

    public String getHost() {
        return this.m_host;
    }

    private void setHost(String host) {
        this.m_host = host;
    }

    public int getPort() {
        return this.m_port;
    }

    private void setPort(int port) {
        this.m_port = port;
    }

    public String getPath() {
        return this.m_path;
    }

    private void setPath(String path) {
        this.m_path = path;
    }

    public Object getProperty(String key) {
        return this.m_properties == null ? null : this.m_properties.get(key);
    }

    public void putProperty(String key, Object value) {
        if (this.m_properties == null) {
            this.m_properties = new HashMap();
        }
        this.m_properties.put(key, value);
        this.address = this.toString();
    }

    public Map getProperties() {
        return this.m_properties == null ? null : (Map)this.m_properties.clone();
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            return this.isEqual(obj) && ((JMXAddress)obj).isEqual(this);
        }
        catch (ClassCastException ignored) {
            return false;
        }
    }

    protected boolean isEqual(Object obj) {
        try {
            return this.address.equals(((JMXAddress)obj).address);
        }
        catch (ClassCastException ignored) {
            return false;
        }
    }

    public Object clone() {
        try {
            JMXAddress clone = (JMXAddress)super.clone();
            if (this.m_properties != null) {
                clone.m_properties = (HashMap)this.m_properties.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException ignored) {
            return null;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("jmx:");
        buffer.append(this.getProtocol()).append("://").append(this.getHost());
        int port = this.getPort();
        if (port > 0) {
            buffer.append(":").append(port);
        }
        buffer.append("/").append(this.getPath());
        if (this.m_properties.size() > 0) {
            TreeMap ordered = new TreeMap(this.m_properties);
            Iterator i = ordered.entrySet().iterator();
            while (i.hasNext()) {
                buffer.append(";");
                Map.Entry entry = i.next();
                buffer.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return buffer.toString();
    }

    private void parse(String url) throws MalformedJMXAddressException {
        String hostSeparator;
        String service;
        if (url == null) {
            throw new MalformedJMXAddressException("JMXAddress cannot be null");
        }
        if (this.m_properties == null) {
            this.m_properties = new HashMap();
        }
        if (!url.startsWith(service = "jmx:")) {
            throw new MalformedJMXAddressException("JMXAddress must start with '" + service + "'");
        }
        int index = (url = url.substring(service.length())).indexOf(hostSeparator = "://");
        if (index < 0) {
            throw new MalformedJMXAddressException("JMXAddress must have a host");
        }
        String protocol = url.substring(0, index).trim();
        String hostAndMore = url.substring(index + hostSeparator.length());
        if (protocol.length() == 0) {
            throw new MalformedJMXAddressException("JMXAddress must have a protocol");
        }
        this.setProtocol(protocol);
        index = hostAndMore.indexOf(47);
        if (index < 0) {
            int semicolon = hostAndMore.indexOf(59);
            if (semicolon < 0) {
                this.parseHostAndPort(hostAndMore);
            } else {
                String hostAndPort = hostAndMore.substring(0, semicolon);
                this.parseHostAndPort(hostAndPort);
                String more = hostAndMore.substring(semicolon + 1);
                this.parseProperties(more);
            }
        } else {
            String hostAndPort = hostAndMore.substring(0, index);
            if (hostAndPort.length() == 0) {
                throw new MalformedJMXAddressException("JMXAddress must have a host");
            }
            this.parseHostAndPort(hostAndPort);
            String pathAndMore = hostAndMore.substring(index + 1);
            if (pathAndMore.length() > 0) {
                int semicolon = pathAndMore.indexOf(59);
                if (semicolon < 0) {
                    String path = pathAndMore;
                    this.setPath(path);
                } else {
                    String path = pathAndMore.substring(0, semicolon);
                    this.setPath(path);
                    String more = pathAndMore.substring(semicolon + 1);
                    this.parseProperties(more);
                }
            }
        }
    }

    private void parseHostAndPort(String hostAndPort) throws MalformedJMXAddressException {
        int colon = hostAndPort.indexOf(58);
        if (colon == 0) {
            throw new MalformedJMXAddressException("JMXAddress must have a host");
        }
        if (colon > 0) {
            String host = hostAndPort.substring(0, colon);
            this.setHost(host);
            String portString = hostAndPort.substring(colon + 1);
            try {
                int port = Integer.parseInt(portString);
                this.setPort(port);
            }
            catch (NumberFormatException x) {
                throw new MalformedJMXAddressException("JMXAddress has an invalid port");
            }
        } else {
            if (hostAndPort.length() == 0) {
                throw new MalformedJMXAddressException("JMXAddress must have a host");
            }
            this.setHost(hostAndPort);
            this.setPort(-1);
        }
    }

    private void parseProperties(String properties) throws MalformedJMXAddressException {
        StringTokenizer tokenizer = new StringTokenizer(properties, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            int equal = token.indexOf(61);
            if (equal <= 0) {
                throw new MalformedJMXAddressException("JMXAddress has an invalid property");
            }
            String key = token.substring(0, equal);
            String value = token.substring(equal + 1);
            this.putProperty(key, value);
        }
    }
}

