/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.http;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mx4j.adaptor.AdaptorServerSocketFactory;
import mx4j.adaptor.PlainAdaptorServerSocketFactory;
import mx4j.adaptor.http.Base64;
import mx4j.adaptor.http.DefaultProcessor;
import mx4j.adaptor.http.HttpAdaptorMBean;
import mx4j.adaptor.http.HttpCommandProcessor;
import mx4j.adaptor.http.HttpException;
import mx4j.adaptor.http.HttpInputStream;
import mx4j.adaptor.http.HttpOutputStream;
import mx4j.adaptor.http.ProcessorMBean;
import mx4j.log.Log;
import mx4j.log.Logger;
import org.w3c.dom.Document;

public class HttpAdaptor
implements HttpAdaptorMBean,
MBeanRegistration {
    private static final String VERSION = "1.1.1";
    private int port = 8080;
    private String host = "localhost";
    private MBeanServer server;
    private ServerSocket serverSocket;
    private boolean alive;
    private Map commands = new HashMap();
    private ProcessorMBean processor = null;
    private ObjectName processorName = null;
    private ProcessorMBean defaultProcessor = new DefaultProcessor();
    private String authenticationMethod = "none";
    private String realm = "MX4J";
    private Map authorizations = new HashMap();
    private AdaptorServerSocketFactory socketFactory = null;
    private ObjectName factoryName;
    private String processorClass;
    private Date startDate;
    private long requestsCount;
    private String[][] defaultCommandProcessors = new String[][]{{"server", "mx4j.adaptor.http.ServerCommandProcessor"}, {"serverbydomain", "mx4j.adaptor.http.ServerByDomainCommandProcessor"}, {"mbean", "mx4j.adaptor.http.MBeanCommandProcessor"}, {"setattributes", "mx4j.adaptor.http.SetAttributesCommandProcessor"}, {"setattribute", "mx4j.adaptor.http.SetAttributeCommandProcessor"}, {"getattribute", "mx4j.adaptor.http.GetAttributeCommandProcessor"}, {"delete", "mx4j.adaptor.http.DeleteMBeanCommandProcessor"}, {"invoke", "mx4j.adaptor.http.InvokeOperationCommandProcessor"}, {"create", "mx4j.adaptor.http.CreateMBeanCommandProcessor"}, {"constructors", "mx4j.adaptor.http.ConstructorsCommandProcessor"}, {"relation", "mx4j.adaptor.http.RelationCommandProcessor"}, {"empty", "mx4j.adaptor.http.EmptyCommandProcessor"}};
    private DocumentBuilder builder;

    public HttpAdaptor() {
    }

    public HttpAdaptor(int port) {
        this.port = port;
    }

    public HttpAdaptor(String host) {
        this.host = host;
    }

    public HttpAdaptor(int port, String host) {
        this.port = port;
        this.host = host;
    }

    public void setPort(int port) {
        if (this.alive) {
            throw new IllegalArgumentException("Not possible to change port with the server running");
        }
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setHost(String host) {
        if (this.alive) {
            throw new IllegalArgumentException("Not possible to change port with the server running");
        }
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setAuthenticationMethod(String method) {
        if (this.alive) {
            throw new IllegalArgumentException("Not possible to change authentication method with the server running");
        }
        if (method == null || !method.equals("none") && !method.equals("basic") && !method.equals("digest")) {
            throw new IllegalArgumentException("Only accept methods none/basic/digest");
        }
        this.authenticationMethod = method;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setProcessor(ProcessorMBean processor) {
        this.processor = processor;
        this.processorName = null;
    }

    public void setProcessorClass(String processorClass) {
        this.processorClass = processorClass;
    }

    public void setProcessorNameString(String processorName) throws MalformedObjectNameException {
        this.processorName = new ObjectName(processorName);
    }

    public void setProcessorName(ObjectName processorName) {
        this.processor = null;
        this.processorName = processorName;
    }

    public ProcessorMBean getProcessor() {
        return this.processor;
    }

    public ObjectName getProcessorName() {
        return this.processorName;
    }

    public void setSocketFactory(AdaptorServerSocketFactory factory) {
        this.factoryName = null;
        this.socketFactory = factory;
    }

    public void setSocketFactoryName(ObjectName factoryName) {
        this.socketFactory = null;
        this.factoryName = factoryName;
    }

    public void setSocketFactoryNameString(String factoryName) throws MalformedObjectNameException {
        this.socketFactory = null;
        this.factoryName = new ObjectName(factoryName);
    }

    public boolean isActive() {
        return this.alive;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public long getRequestsCount() {
        return this.requestsCount;
    }

    public String getVersion() {
        return VERSION;
    }

    public void addCommandProcessor(String path, HttpCommandProcessor processor) {
        this.commands.put(path, processor);
        if (this.alive) {
            processor.setMBeanServer(this.server);
            processor.setDocumentBuilder(this.builder);
        }
    }

    public void addCommandProcessor(String path, String processorClass) {
        try {
            HttpCommandProcessor processor = (HttpCommandProcessor)Class.forName(processorClass).newInstance();
            this.addCommandProcessor(path, processor);
        }
        catch (Exception e) {
            Logger log = this.getLogger();
            log.error("Exception creating Command Processor of class " + processorClass, e);
        }
    }

    public void removeCommandProcessor(String path) {
        if (this.commands.containsKey(path)) {
            this.commands.remove(path);
        }
    }

    public void start() throws IOException {
        final Logger log = this.getLogger();
        if (this.server != null) {
            this.serverSocket = this.createServerSocket();
            if (this.serverSocket == null) {
                log.error("Server socket is null");
                return;
            }
            if (this.processorClass != null && this.processorName != null) {
                if (log.isEnabledFor(20)) {
                    log.info("Building processor class of type " + this.processorClass + " and name " + this.processorName);
                }
                try {
                    this.server.createMBean(this.processorClass, this.processorName, null);
                }
                catch (JMException e) {
                    log.error("Exception creating processor class", e);
                }
            }
            Iterator i = this.commands.values().iterator();
            while (i.hasNext()) {
                HttpCommandProcessor processor = (HttpCommandProcessor)i.next();
                processor.setMBeanServer(this.server);
                processor.setDocumentBuilder(this.builder);
            }
            if (log.isEnabledFor(20)) {
                log.info("HttpAdaptor server listening on port " + this.port);
            }
            this.alive = true;
            Thread serverThread = new Thread(new Runnable(){

                public void run() {
                    if (log.isEnabledFor(20)) {
                        log.info("HttpAdaptor version 1.1.1 started");
                    }
                    HttpAdaptor.this.startDate = new Date();
                    HttpAdaptor.this.requestsCount = 0L;
                    while (HttpAdaptor.this.alive) {
                        try {
                            Socket client = null;
                            client = HttpAdaptor.this.serverSocket.accept();
                            if (!HttpAdaptor.this.alive) break;
                            HttpAdaptor.this.requestsCount++;
                            new HttpClient(client).start();
                        }
                        catch (InterruptedIOException e) {
                        }
                        catch (IOException e) {
                        }
                        catch (Exception e) {
                            log.warn("Exception during request processing", e);
                        }
                        catch (Error e) {
                            log.error("Error during request processing", e);
                        }
                    }
                    try {
                        HttpAdaptor.this.serverSocket.close();
                    }
                    catch (IOException e) {
                        log.warn("Exception closing the server", e);
                    }
                    HttpAdaptor.this.serverSocket = null;
                    HttpAdaptor.this.alive = false;
                    if (log.isEnabledFor(20)) {
                        log.info("Server stopped");
                    }
                }
            });
            serverThread.start();
        } else if (log.isEnabledFor(20)) {
            log.info("Start failed, no server target server has been set");
        }
    }

    public void restart() throws IOException {
        this.stop();
        this.start();
    }

    public void stop() {
        block3: {
            try {
                if (!this.alive) break block3;
                this.alive = false;
                new Socket(this.host, this.port);
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addAuthorization(String username, String password) {
        if (username == null || password == null) {
            throw new IllegalArgumentException("username and passwords cannot be null");
        }
        this.authorizations.put(username, password);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.buildCommands();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.stop();
    }

    public void postDeregister() {
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    private ServerSocket createServerSocket() throws IOException {
        if (this.socketFactory == null) {
            if (this.factoryName == null) {
                this.socketFactory = new PlainAdaptorServerSocketFactory();
                return this.socketFactory.createServerSocket(this.port, 50, this.host);
            }
            try {
                return (ServerSocket)this.server.invoke(this.factoryName, "createServerSocket", new Object[]{new Integer(this.port), new Integer(50), this.host}, new String[]{"int", "int", "java.lang.String"});
            }
            catch (Exception x) {
                Logger log = this.getLogger();
                log.error("Exception invoking AdaptorServerSocketFactory via MBeanServer", x);
            }
        } else {
            return this.socketFactory.createServerSocket(this.port, 50, this.host);
        }
        return null;
    }

    private boolean isUsernameValid(String username, String password) {
        if (this.authorizations.containsKey(username)) {
            return password.equals(this.authorizations.get(username));
        }
        return false;
    }

    protected HttpCommandProcessor getProcessor(String path) {
        return (HttpCommandProcessor)this.commands.get(path);
    }

    protected void buildCommands() {
        Logger log = this.getLogger();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.builder = factory.newDocumentBuilder();
            int i = 0;
            while (i < this.defaultCommandProcessors.length) {
                try {
                    HttpCommandProcessor processor = (HttpCommandProcessor)Class.forName(this.defaultCommandProcessors[i][1]).newInstance();
                    this.commands.put(this.defaultCommandProcessors[i][0], processor);
                }
                catch (Exception e) {
                    log.warn("Exception building command procesor", e);
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            log.error("Exception building the Document Factories", e);
        }
    }

    protected void postProcess(HttpOutputStream out, HttpInputStream in, Document document) throws IOException, JMException {
        boolean processed = false;
        if (this.processorName != null) {
            if (this.server.isRegistered(this.processorName) && this.server.isInstanceOf(this.processorName, "mx4j.adaptor.http.ProcessorMBean")) {
                this.server.invoke(this.processorName, "writeResponse", new Object[]{out, in, document}, new String[]{"mx4j.adaptor.http.HttpOutputStream", "mx4j.adaptor.http.HttpInputStream", "org.w3c.dom.Document"});
                processed = true;
            } else {
                Logger log = this.getLogger();
                if (log.isEnabledFor(0)) {
                    log.trace(this.processorName + " not found");
                }
            }
        }
        if (!processed && this.processor != null) {
            this.processor.writeResponse(out, in, document);
            processed = true;
        }
        if (!processed) {
            this.defaultProcessor.writeResponse(out, in, document);
        }
    }

    protected void findUnknownElement(String path, HttpOutputStream out, HttpInputStream in) throws IOException, JMException {
        boolean processed = false;
        if (this.processorName != null) {
            if (this.server.isRegistered(this.processorName) && this.server.isInstanceOf(this.processorName, "mx4j.adaptor.http.ProcessorMBean")) {
                this.server.invoke(this.processorName, "notFoundElement", new Object[]{path, out, in}, new String[]{"java.lang.String", "mx4j.adaptor.http.HttpOutputStream", "mx4j.adaptor.http.HttpInputStream"});
                processed = true;
            } else {
                Logger log = this.getLogger();
                if (log.isEnabledFor(0)) {
                    log.trace(this.processorName + " not found");
                }
            }
        }
        if (!processed && this.processor != null) {
            this.processor.notFoundElement(path, out, in);
            processed = true;
        }
        if (!processed) {
            this.defaultProcessor.notFoundElement(path, out, in);
        }
    }

    protected String preProcess(String path) throws IOException, JMException {
        boolean processed = false;
        if (this.processorName != null) {
            Logger log = this.getLogger();
            if (log.isEnabledFor(0)) {
                log.trace("Preprocess using " + this.processorName);
            }
            if (this.server.isRegistered(this.processorName) && this.server.isInstanceOf(this.processorName, "mx4j.adaptor.http.ProcessorMBean")) {
                if (log.isEnabledFor(0)) {
                    log.trace("Preprocessing");
                }
                path = (String)this.server.invoke(this.processorName, "preProcess", new Object[]{path}, new String[]{"java.lang.String"});
                processed = true;
            } else if (log.isEnabledFor(0)) {
                log.trace(this.processorName + " not found");
            }
        }
        if (!processed && this.processor != null) {
            path = this.processor.preProcess(path);
            processed = true;
        }
        if (!processed) {
            path = this.defaultProcessor.preProcess(path);
        }
        return path;
    }

    protected void postProcess(HttpOutputStream out, HttpInputStream in, Exception e) throws IOException, JMException {
        boolean processed = false;
        if (this.processorName != null) {
            if (this.server.isRegistered(this.processorName) && this.server.isInstanceOf(this.processorName, "mx4j.adaptor.http.ProcessorMBean")) {
                this.server.invoke(this.processorName, "writeError", new Object[]{out, in, e}, new String[]{"mx4j.adaptor.http.HttpOutputStream", "mx4j.adaptor.http.HttpInputStream", "java.lang.Exception"});
                processed = true;
            } else {
                Logger log = this.getLogger();
                if (log.isEnabledFor(0)) {
                    log.trace(this.processorName + " not found");
                }
            }
        }
        if (!processed && this.processor != null) {
            this.processor.writeError(out, in, e);
            processed = true;
        }
        if (!processed) {
            this.defaultProcessor.writeError(out, in, e);
        }
    }

    private class HttpClient
    extends Thread {
        private Socket client;

        HttpClient(Socket client) {
            this.client = client;
        }

        public boolean isValid(String authorizationString) {
            String decodeString;
            if (HttpAdaptor.this.authenticationMethod.startsWith("basic") && (decodeString = Base64.decodeToString(authorizationString = authorizationString.substring(5, authorizationString.length()))).indexOf(":") > 0) {
                try {
                    StringTokenizer tokens = new StringTokenizer(decodeString, ":");
                    String username = tokens.nextToken();
                    String password = tokens.nextToken();
                    return HttpAdaptor.this.isUsernameValid(username, password);
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }

        private boolean handleAuthentication(HttpInputStream in, HttpOutputStream out) throws IOException {
            if (HttpAdaptor.this.authenticationMethod.equals("basic")) {
                String result = in.getHeader("authorization");
                if (result != null) {
                    if (this.isValid(result)) {
                        return true;
                    }
                    throw new HttpException(403, "Authentication failed");
                }
                out.setCode(401);
                out.setHeader("WWW-Authenticate", "Basic realm=\"" + HttpAdaptor.this.realm + "\"");
                out.sendHeaders();
                out.flush();
                return false;
            }
            if (HttpAdaptor.this.authenticationMethod.equals("digest")) {
                // empty if block
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Logger log = HttpAdaptor.this.getLogger();
            HttpInputStream httpIn = null;
            BufferedOutputStream httpOut = null;
            try {
                OutputStream out;
                String postPath;
                InputStream in = this.client.getInputStream();
                httpIn = new HttpInputStream(in);
                httpIn.readRequest();
                String path = httpIn.getPath();
                String queryString = httpIn.getQueryString();
                if (log.isEnabledFor(20)) {
                    log.info("Request " + path + (queryString == null ? "" : "?" + queryString));
                }
                if (!(postPath = HttpAdaptor.this.preProcess(path)).equals(path)) {
                    if (log.isEnabledFor(20)) {
                        log.info("Processor replaced path " + path + " with the path " + postPath);
                    }
                    path = postPath;
                }
                if (!this.handleAuthentication(httpIn, (HttpOutputStream)(httpOut = new HttpOutputStream(out = this.client.getOutputStream(), httpIn)))) {
                    return;
                }
                HttpCommandProcessor processor = HttpAdaptor.this.getProcessor(path.substring(1, path.length()));
                if (processor == null) {
                    if (log.isEnabledFor(20)) {
                        log.info("No suitable command processor found, requesting from processor path " + path);
                    }
                    HttpAdaptor.this.findUnknownElement(path, (HttpOutputStream)httpOut, httpIn);
                } else {
                    Document document = processor.executeRequest(httpIn);
                    HttpAdaptor.this.postProcess((HttpOutputStream)httpOut, httpIn, document);
                }
            }
            catch (Exception ex) {
                log.warn("Exception during http request", ex);
                if (httpOut != null) {
                    try {
                        HttpAdaptor.this.postProcess((HttpOutputStream)httpOut, httpIn, ex);
                    }
                    catch (IOException e) {
                        log.warn("IOException during http request", e);
                    }
                    catch (JMException e) {
                        log.warn("JMException during http request", e);
                    }
                }
            }
            catch (Error ex) {
                log.error("Error during http request ", ex);
            }
            finally {
                try {
                    if (httpOut != null) {
                        httpOut.flush();
                    }
                    this.client.close();
                }
                catch (IOException e) {
                    log.warn("Exception during request processing", e);
                }
            }
        }
    }
}

