/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.extensions.pkgmgr;

import java.io.File;
import org.apache.avalon.excalibur.extension.Extension;

public final class OptionalPackage {
    private final File m_file;
    private final Extension[] m_available;
    private final Extension[] m_required;

    public static final File[] toFiles(OptionalPackage[] packages) {
        File[] results = new File[packages.length];
        for (int i = 0; i < packages.length; ++i) {
            results[i] = packages[i].getFile();
        }
        return results;
    }

    public OptionalPackage(File file, Extension[] available, Extension[] required) {
        if (null == file) {
            throw new NullPointerException("file");
        }
        if (null == available) {
            throw new NullPointerException("available");
        }
        if (null == required) {
            throw new NullPointerException("required");
        }
        this.m_file = file;
        this.m_available = available;
        this.m_required = required;
    }

    public File getFile() {
        return this.m_file;
    }

    public Extension[] getRequiredExtensions() {
        return this.m_required;
    }

    public Extension[] getAvailableExtensions() {
        return this.m_available;
    }

    public boolean isCompatible(Extension extension) {
        for (int i = 0; i < this.m_available.length; ++i) {
            if (!this.m_available[i].isCompatibleWith(extension)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer("OptionalPackage[");
        sb.append(this.m_file);
        sb.append(", Available[");
        for (i = 0; i < this.m_available.length; ++i) {
            if (0 != i) {
                sb.append(" ");
            }
            sb.append(this.m_available[i].getExtensionName());
        }
        sb.append("], Required[");
        for (i = 0; i < this.m_required.length; ++i) {
            if (0 != i) {
                sb.append(" ");
            }
            sb.append(this.m_required[i].getExtensionName());
        }
        sb.append("] ]");
        return sb.toString();
    }
}

