/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.application;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.WrapperComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.DefaultServiceManager;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.phoenix.components.application.DefaultBlockContext;
import org.apache.avalon.phoenix.containerkit.lifecycle.ResourceProvider;
import org.apache.avalon.phoenix.containerkit.metadata.DependencyMetaData;
import org.apache.avalon.phoenix.containerkit.profile.ComponentProfile;
import org.apache.avalon.phoenix.framework.info.DependencyDescriptor;
import org.apache.avalon.phoenix.interfaces.Application;
import org.apache.avalon.phoenix.interfaces.ApplicationContext;
import org.apache.excalibur.instrument.InstrumentManager;

class BlockResourceProvider
extends AbstractLogEnabled
implements ResourceProvider {
    private final ApplicationContext m_context;
    private final Application m_application;

    public BlockResourceProvider(ApplicationContext context, Application application) {
        if (null == context) {
            throw new NullPointerException("context");
        }
        if (null == application) {
            throw new NullPointerException("application");
        }
        this.m_context = context;
        this.m_application = application;
    }

    public Object createObject(Object entry) throws Exception {
        ComponentProfile profile = this.getProfileFor(entry);
        ClassLoader classLoader = this.m_context.getClassLoader();
        String classname = profile.getInfo().getDescriptor().getImplementationKey();
        Class<?> clazz = classLoader.loadClass(classname);
        return clazz.newInstance();
    }

    public Logger createLogger(Object entry) throws Exception {
        ComponentProfile profile = this.getProfileFor(entry);
        String name = profile.getMetaData().getName();
        return this.m_context.getLogger(name);
    }

    public InstrumentManager createInstrumentManager(Object entry) throws Exception {
        return this.m_context.getInstrumentManager();
    }

    public String createInstrumentableName(Object entry) throws Exception {
        ComponentProfile profile = this.getProfileFor(entry);
        String name = profile.getMetaData().getName();
        return this.m_context.getInstrumentableName(name);
    }

    public Context createContext(Object entry) throws Exception {
        ComponentProfile profile = this.getProfileFor(entry);
        return new DefaultBlockContext(profile.getMetaData().getName(), this.m_context);
    }

    public ComponentManager createComponentManager(Object entry) throws Exception {
        ServiceManager serviceManager = this.createServiceManager(entry);
        return new WrapperComponentManager(serviceManager);
    }

    public ServiceManager createServiceManager(Object entry) throws Exception {
        Map serviceMap = this.createServiceMap(entry);
        DefaultServiceManager manager = new DefaultServiceManager();
        Iterator iterator = serviceMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = serviceMap.get(key);
            manager.put(key, value);
        }
        return manager;
    }

    private Map createServiceMap(Object entry) throws Exception {
        ComponentProfile metaData = this.getProfileFor(entry);
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Cloneable> sets = new HashMap<String, Cloneable>();
        DependencyMetaData[] roles = metaData.getMetaData().getDependencies();
        for (int i = 0; i < roles.length; ++i) {
            DependencyMetaData role = roles[i];
            Object dependency = this.m_application.getBlock(role.getProviderName());
            DependencyDescriptor candidate = metaData.getInfo().getDependency(role.getKey());
            String key = role.getKey();
            if (candidate.isArray()) {
                ArrayList<Object> list = (ArrayList<Object>)sets.get(key);
                if (null == list) {
                    list = new ArrayList<Object>();
                    sets.put(key, list);
                }
                list.add(dependency);
                continue;
            }
            if (candidate.isMap()) {
                HashMap<String, Object> smap = (HashMap<String, Object>)sets.get(key);
                if (null == smap) {
                    smap = new HashMap<String, Object>();
                    sets.put(key, smap);
                }
                smap.put(role.getAlias(), dependency);
                continue;
            }
            map.put(key, dependency);
        }
        Iterator iterator = sets.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = sets.get(key);
            if (value instanceof List) {
                List list = (List)value;
                DependencyDescriptor dependency = metaData.getInfo().getDependency(key);
                Object[] result = this.toArray(list, dependency.getComponentType());
                map.put(key, result);
                if (!key.equals(dependency.getType())) continue;
                String classname = "[L" + dependency.getComponentType() + ";";
                map.put(classname, result);
                continue;
            }
            Map smap = Collections.unmodifiableMap((Map)value);
            map.put(key, smap);
        }
        return map;
    }

    private Object[] toArray(List list, String type) throws ClassNotFoundException {
        ClassLoader classLoader = list.get(0).getClass().getClassLoader();
        Class<?> clazz = classLoader.loadClass(type);
        Object[] elements = (Object[])Array.newInstance(clazz, list.size());
        return list.toArray(elements);
    }

    public Configuration createConfiguration(Object entry) throws Exception {
        ComponentProfile metaData = this.getProfileFor(entry);
        return metaData.getMetaData().getConfiguration();
    }

    public Parameters createParameters(Object entry) throws Exception {
        Configuration configuration = this.createConfiguration(entry);
        Parameters parameters = Parameters.fromConfiguration((Configuration)configuration);
        parameters.makeReadOnly();
        return parameters;
    }

    private ComponentProfile getProfileFor(Object entry) {
        return (ComponentProfile)entry;
    }
}

