/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.xmlpolicy.builder;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.Policy;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.StringTokenizer;
import org.realityforge.xmlpolicy.builder.PolicyResolver;
import org.realityforge.xmlpolicy.metadata.GrantMetaData;
import org.realityforge.xmlpolicy.metadata.KeyStoreMetaData;
import org.realityforge.xmlpolicy.metadata.PermissionMetaData;
import org.realityforge.xmlpolicy.metadata.PolicyMetaData;

public class PolicyBuilder {
    static /* synthetic */ Class class$java$lang$String;

    public Policy buildPolicy(PolicyMetaData policy, PolicyResolver resolver) throws Exception {
        if (null == policy) {
            throw new NullPointerException("policy");
        }
        if (null == resolver) {
            throw new NullPointerException("resolver");
        }
        Map keyStores = this.createKeyStores(policy.getKeyStores(), resolver);
        HashMap<CodeSource, Permission[]> grants = new HashMap<CodeSource, Permission[]>();
        this.processGrants(policy.getGrants(), keyStores, grants, resolver);
        CodeSource codeSource = this.createDefaultCodeSource();
        Permission[] permissions = this.getDefaultPermissions();
        grants.put(codeSource, permissions);
        return resolver.createPolicy(grants);
    }

    private void processGrants(GrantMetaData[] metaDatas, Map keyStores, Map grants, PolicyResolver resolver) throws Exception {
        int i = 0;
        while (i < metaDatas.length) {
            this.processGrant(metaDatas[i], keyStores, grants, resolver);
            ++i;
        }
    }

    private void processGrant(GrantMetaData metaData, Map keyStores, Map grants, PolicyResolver resolver) throws Exception {
        URL url = resolver.resolveLocation(metaData.getCodebase());
        Certificate[] signers = this.getSigners(metaData.getSignedBy(), metaData.getKeyStore(), keyStores);
        CodeSource codeSource = new CodeSource(url, signers);
        Permission[] permissions = this.createPermissions(metaData.getPermissions(), keyStores);
        grants.put(codeSource, permissions);
    }

    private Permission[] createPermissions(PermissionMetaData[] metaDatas, Map keyStores) throws Exception {
        ArrayList<Permission> set = new ArrayList<Permission>();
        int i = 0;
        while (i < metaDatas.length) {
            Permission permission = this.createPermission(metaDatas[i], keyStores);
            set.add(permission);
            ++i;
        }
        return set.toArray(new Permission[set.size()]);
    }

    private Permission createPermission(PermissionMetaData metaData, Map keyStores) throws Exception {
        String type = metaData.getClassname();
        String actions = metaData.getAction();
        String signedBy = metaData.getSignedBy();
        String keyStoreName = metaData.getKeyStore();
        String target = metaData.getTarget();
        Certificate[] signers = this.getSigners(signedBy, keyStoreName, keyStores);
        return this.createPermission(type, target, actions, signers);
    }

    private Map createKeyStores(KeyStoreMetaData[] metaDatas, PolicyResolver resolver) throws Exception {
        HashMap<String, KeyStore> keyStores = new HashMap<String, KeyStore>();
        int i = 0;
        while (i < metaDatas.length) {
            KeyStoreMetaData metaData = metaDatas[i];
            String name = metaData.getName();
            try {
                URL url = resolver.resolveLocation(metaData.getLocation());
                KeyStore keyStore = this.createKeyStore(metaData.getType(), url);
                keyStores.put(name, keyStore);
            }
            catch (Exception e) {
                String message = "Error creating keystore " + name + ". Due to " + e;
                throw new Exception(message);
            }
            ++i;
        }
        return keyStores;
    }

    private final Permission createPermission(String type, String target, String actions, Certificate[] signers) throws Exception {
        if (null != signers) {
            return new UnresolvedPermission(type, target, actions, signers);
        }
        try {
            Class<?> clazz = Class.forName(type);
            Class[] paramClasses = null;
            Object[] params = null;
            if (null == actions && null == target) {
                paramClasses = new Class[]{};
                params = new Object[]{};
            } else if (null == actions) {
                paramClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PolicyBuilder.class$("java.lang.String")) : class$java$lang$String};
                params = new Object[]{target};
            } else {
                paramClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PolicyBuilder.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PolicyBuilder.class$("java.lang.String")) : class$java$lang$String};
                params = new Object[]{target, actions};
            }
            Constructor<?> constructor = clazz.getConstructor(paramClasses);
            return (Permission)constructor.newInstance(params);
        }
        catch (ClassNotFoundException cnfe) {
            return new UnresolvedPermission(type, target, actions, signers);
        }
    }

    protected KeyStore createKeyStore(String type, URL url) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(type);
        InputStream ins = url.openStream();
        keyStore.load(ins, null);
        return keyStore;
    }

    private Certificate[] getSigners(String signedBy, String keyStoreName, Map keyStores) throws Exception {
        if (null == signedBy) {
            return null;
        }
        KeyStore keyStore = this.getKeyStore(keyStoreName, keyStores);
        return this.getCertificates(signedBy, keyStore);
    }

    private Certificate[] getCertificates(String signedBy, KeyStore keyStore) throws Exception {
        ArrayList<Certificate> certificateSet = new ArrayList<Certificate>();
        StringTokenizer st = new StringTokenizer(signedBy, ",");
        while (st.hasMoreTokens()) {
            String alias = st.nextToken().trim();
            Certificate certificate = null;
            try {
                certificate = keyStore.getCertificate(alias);
            }
            catch (KeyStoreException kse) {
                String message = "Unable to get certificate for alias " + alias + " due to " + kse;
                throw new Exception(message);
            }
            if (null == certificate) {
                String message = "Missing certificate for alias " + alias;
                throw new Exception(message);
            }
            if (certificateSet.contains(certificate)) continue;
            certificateSet.add(certificate);
        }
        return certificateSet.toArray(new Certificate[certificateSet.size()]);
    }

    private KeyStore getKeyStore(String keyStoreName, Map keyStores) throws Exception {
        KeyStore keyStore = (KeyStore)keyStores.get(keyStoreName);
        if (null == keyStore) {
            String message = "Missing keystore named: " + keyStoreName;
            throw new Exception(message);
        }
        return keyStore;
    }

    private CodeSource createDefaultCodeSource() {
        URL url;
        try {
            url = new URL("file:/-");
        }
        catch (MalformedURLException mue) {
            throw new IllegalStateException(mue.getMessage());
        }
        CodeSource codeSource = new CodeSource(url, null);
        return codeSource;
    }

    private Permission[] getDefaultPermissions() {
        ArrayList<PropertyPermission> list = new ArrayList<PropertyPermission>();
        list.add(new PropertyPermission("os.name", "read"));
        list.add(new PropertyPermission("os.arch", "read"));
        list.add(new PropertyPermission("os.version", "read"));
        list.add(new PropertyPermission("file.separator", "read"));
        list.add(new PropertyPermission("path.separator", "read"));
        list.add(new PropertyPermission("line.separator", "read"));
        list.add(new PropertyPermission("java.version", "read"));
        list.add(new PropertyPermission("java.vendor", "read"));
        list.add(new PropertyPermission("java.vendor.url", "read"));
        list.add(new PropertyPermission("java.class.version", "read"));
        list.add(new PropertyPermission("java.vm.version", "read"));
        list.add(new PropertyPermission("java.vm.vendor", "read"));
        list.add(new PropertyPermission("java.vm.name", "read"));
        list.add(new PropertyPermission("java.specification.version", "read"));
        list.add(new PropertyPermission("java.specification.vendor", "read"));
        list.add(new PropertyPermission("java.specification.name", "read"));
        list.add(new PropertyPermission("java.vm.specification.version", "read"));
        list.add(new PropertyPermission("java.vm.specification.vendor", "read"));
        list.add(new PropertyPermission("java.vm.specification.name", "read"));
        return list.toArray(new Permission[list.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

