/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.framework.tools.qdox;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.ArrayList;
import org.apache.avalon.phoenix.framework.info.Attribute;
import org.apache.avalon.phoenix.framework.info.ComponentDescriptor;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.framework.info.ContextDescriptor;
import org.apache.avalon.phoenix.framework.info.DependencyDescriptor;
import org.apache.avalon.phoenix.framework.info.LoggerDescriptor;
import org.apache.avalon.phoenix.framework.info.SchemaDescriptor;
import org.apache.avalon.phoenix.framework.info.ServiceDescriptor;
import org.apache.avalon.phoenix.framework.tools.infobuilder.LegacyUtil;
import org.apache.avalon.phoenix.framework.tools.qdox.AbstractInfoBuilder;

public class LegacyInfoBuilder
extends AbstractInfoBuilder {
    public ComponentInfo buildComponentInfo(JavaClass javaClass) {
        ComponentDescriptor component = this.buildComponent(javaClass);
        ServiceDescriptor[] services = this.buildServices(javaClass);
        ContextDescriptor context = LegacyUtil.CONTEXT_DESCRIPTOR;
        LoggerDescriptor[] loggers = LoggerDescriptor.EMPTY_SET;
        SchemaDescriptor schema = this.buildConfigurationSchema(javaClass);
        DependencyDescriptor[] dependencies = this.buildDependencies(javaClass);
        return new ComponentInfo(component, services, loggers, context, dependencies, schema, null);
    }

    private ComponentDescriptor buildComponent(JavaClass javaClass) {
        String type = javaClass.getFullyQualifiedName();
        return new ComponentDescriptor(type, Attribute.EMPTY_SET);
    }

    private ServiceDescriptor[] buildServices(JavaClass javaClass) {
        ArrayList<ServiceDescriptor> services = new ArrayList<ServiceDescriptor>();
        DocletTag[] serviceTags = javaClass.getTagsByName("phoenix:service");
        for (int i = 0; i < serviceTags.length; ++i) {
            String type = this.getNamedParameter(serviceTags[i], "name");
            ServiceDescriptor service = new ServiceDescriptor(type, Attribute.EMPTY_SET);
            services.add(service);
        }
        DocletTag[] mxTags = javaClass.getTagsByName("phoenix:mx");
        for (int i = 0; i < mxTags.length; ++i) {
            String type = this.getNamedParameter(mxTags[i], "name");
            ServiceDescriptor service = new ServiceDescriptor(type, new Attribute[]{LegacyUtil.MX_ATTRIBUTE});
            services.add(service);
        }
        return services.toArray(new ServiceDescriptor[services.size()]);
    }

    private SchemaDescriptor buildConfigurationSchema(JavaClass javaClass) {
        JavaMethod method = this.getLifecycleMethod(javaClass, "configure", "org.apache.avalon.framework.configuration.Configuration");
        if (null == method) {
            return null;
        }
        DocletTag tag = method.getTagByName("phoenix:configuration-schema");
        if (null == tag) {
            return null;
        }
        String type = this.getNamedParameter(tag, "type");
        String classname = javaClass.getFullyQualifiedName();
        String location = LegacyUtil.getSchemaLocationFor(classname);
        return new SchemaDescriptor(location, type, Attribute.EMPTY_SET);
    }

    private DependencyDescriptor[] buildDependencies(JavaClass javaClass) {
        JavaMethod method = this.getLifecycleMethod(javaClass, "compose", "org.apache.avalon.framework.component.ComponentManager");
        if (null == method) {
            method = this.getLifecycleMethod(javaClass, "service", "org.apache.avalon.framework.service.ServiceManager");
        }
        if (null == method) {
            return DependencyDescriptor.EMPTY_SET;
        }
        ArrayList<DependencyDescriptor> deps = new ArrayList<DependencyDescriptor>();
        DocletTag[] tags = method.getTagsByName("phoenix:dependency");
        for (int i = 0; i < tags.length; ++i) {
            DocletTag tag = tags[i];
            String unresolvedType = this.getNamedParameter(tag, "name");
            String type = this.resolveType(javaClass, unresolvedType);
            String key = this.getNamedParameter(tag, "role", type);
            DependencyDescriptor dependency = new DependencyDescriptor(key, type, false, Attribute.EMPTY_SET);
            deps.add(dependency);
        }
        return deps.toArray(new DependencyDescriptor[deps.size()]);
    }
}

