/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.framework.tools.qdox;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.ArrayList;
import org.apache.avalon.phoenix.framework.info.Attribute;
import org.apache.avalon.phoenix.framework.info.ComponentDescriptor;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.framework.info.ContextDescriptor;
import org.apache.avalon.phoenix.framework.info.DependencyDescriptor;
import org.apache.avalon.phoenix.framework.info.EntryDescriptor;
import org.apache.avalon.phoenix.framework.info.LoggerDescriptor;
import org.apache.avalon.phoenix.framework.info.SchemaDescriptor;
import org.apache.avalon.phoenix.framework.info.ServiceDescriptor;
import org.apache.avalon.phoenix.framework.tools.qdox.AbstractInfoBuilder;

public class DefaultInfoBuilder
extends AbstractInfoBuilder {
    public ComponentInfo buildComponentInfo(JavaClass javaClass) {
        ComponentDescriptor component = this.buildComponent(javaClass);
        ServiceDescriptor[] services = this.buildServices(javaClass);
        ContextDescriptor context = this.buildContext(javaClass);
        LoggerDescriptor[] loggers = this.buildLoggers(javaClass);
        SchemaDescriptor configurationSchema = this.buildConfigurationSchema(javaClass);
        SchemaDescriptor parametersSchema = this.buildParametersSchema(javaClass);
        DependencyDescriptor[] dependencies = this.buildDependencies(javaClass);
        return new ComponentInfo(component, services, loggers, context, dependencies, configurationSchema, parametersSchema);
    }

    private ComponentDescriptor buildComponent(JavaClass javaClass) {
        String type = javaClass.getFullyQualifiedName();
        return new ComponentDescriptor(type, Attribute.EMPTY_SET);
    }

    private ServiceDescriptor[] buildServices(JavaClass javaClass) {
        ArrayList<ServiceDescriptor> services = new ArrayList<ServiceDescriptor>();
        DocletTag[] tags = javaClass.getTagsByName("phoenix.service");
        for (int i = 0; i < tags.length; ++i) {
            DocletTag tag = tags[i];
            String unresolvedType = this.getNamedParameter(tag, "type");
            String type = this.resolveType(javaClass, unresolvedType);
            ServiceDescriptor service = new ServiceDescriptor(type, Attribute.EMPTY_SET);
            services.add(service);
        }
        return services.toArray(new ServiceDescriptor[services.size()]);
    }

    private LoggerDescriptor[] buildLoggers(JavaClass javaClass) {
        JavaMethod method = this.getLifecycleMethod(javaClass, "enableLogging", "org.apache.avalon.framework.logger.Logger");
        if (null == method) {
            return LoggerDescriptor.EMPTY_SET;
        }
        ArrayList<LoggerDescriptor> loggers = new ArrayList<LoggerDescriptor>();
        DocletTag[] tags = method.getTagsByName("phoenix.logger");
        for (int i = 0; i < tags.length; ++i) {
            String name = this.getNamedParameter(tags[i], "name", "");
            LoggerDescriptor logger = new LoggerDescriptor(name, Attribute.EMPTY_SET);
            loggers.add(logger);
        }
        return loggers.toArray(new LoggerDescriptor[loggers.size()]);
    }

    private ContextDescriptor buildContext(JavaClass javaClass) {
        JavaMethod method = this.getLifecycleMethod(javaClass, "contextualize", "org.apache.avalon.framework.context.Context");
        if (null == method) {
            return ContextDescriptor.EMPTY_CONTEXT;
        }
        String type = "org.apache.avalon.framework.context.Context";
        DocletTag tag = method.getTagByName("phoenix.context");
        if (null != tag && null != tag.getNamedParameter("type")) {
            String value = this.getNamedParameter(tag, "type");
            type = this.resolveType(javaClass, value);
        }
        ArrayList<EntryDescriptor> entrySet = new ArrayList<EntryDescriptor>();
        DocletTag[] tags = method.getTagsByName("phoenix.entry");
        for (int i = 0; i < tags.length; ++i) {
            String key = this.getNamedParameter(tags[i], "key");
            String entryType = this.getNamedParameter(tags[i], "type");
            String optional = this.getNamedParameter(tags[i], "optional", "false");
            boolean isOptional = "true".equals(optional);
            EntryDescriptor entry = new EntryDescriptor(key, entryType, isOptional, Attribute.EMPTY_SET);
            entrySet.add(entry);
        }
        EntryDescriptor[] entrys = entrySet.toArray(new EntryDescriptor[entrySet.size()]);
        return new ContextDescriptor(type, entrys, Attribute.EMPTY_SET);
    }

    private SchemaDescriptor buildConfigurationSchema(JavaClass javaClass) {
        JavaMethod method = this.getLifecycleMethod(javaClass, "configure", "org.apache.avalon.framework.configuration.Configuration");
        if (null == method) {
            return null;
        }
        DocletTag tag = method.getTagByName("phoenix.configuration");
        if (null == tag) {
            return null;
        }
        String location = this.getNamedParameter(tag, "location", "");
        String type = this.getNamedParameter(tag, "type", "");
        return new SchemaDescriptor(location, type, Attribute.EMPTY_SET);
    }

    private SchemaDescriptor buildParametersSchema(JavaClass javaClass) {
        JavaMethod method = this.getLifecycleMethod(javaClass, "parameterize", "org.apache.avalon.framework.parameters.Parameters");
        if (null == method) {
            return null;
        }
        DocletTag tag = method.getTagByName("phoenix.parameters");
        if (null == tag) {
            return null;
        }
        String location = this.getNamedParameter(tag, "location", "");
        String type = this.getNamedParameter(tag, "type", "");
        return new SchemaDescriptor(location, type, Attribute.EMPTY_SET);
    }

    private DependencyDescriptor[] buildDependencies(JavaClass javaClass) {
        JavaMethod method = this.getLifecycleMethod(javaClass, "compose", "org.apache.avalon.framework.component.ComponentManager");
        if (null == method) {
            method = this.getLifecycleMethod(javaClass, "service", "org.apache.avalon.framework.service.ServiceManager");
        }
        if (null == method) {
            return DependencyDescriptor.EMPTY_SET;
        }
        ArrayList<DependencyDescriptor> deps = new ArrayList<DependencyDescriptor>();
        DocletTag[] tags = method.getTagsByName("phoenix.dependency");
        for (int i = 0; i < tags.length; ++i) {
            DocletTag tag = tags[i];
            String unresolvedType = this.getNamedParameter(tag, "type");
            String type = this.resolveType(javaClass, unresolvedType);
            String key = this.getNamedParameter(tag, "key", type);
            String optional = this.getNamedParameter(tag, "optional", "false");
            boolean isOptional = "true".equals(optional);
            DependencyDescriptor dependency = new DependencyDescriptor(key, type, isOptional, Attribute.EMPTY_SET);
            deps.add(dependency);
        }
        return deps.toArray(new DependencyDescriptor[deps.size()]);
    }
}

