/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.metainfo;

import org.apache.avalon.framework.Version;

public final class ServiceDescriptor {
    public static final String ARRAY_POSTFIX = "[]";
    public static final String MAP_POSTFIX = "{}";
    private final Version m_version;
    private final String m_name;

    public ServiceDescriptor(String name, Version version) {
        this.m_name = name;
        this.m_version = version;
    }

    public Version getVersion() {
        return this.m_version;
    }

    public String getName() {
        return this.m_name;
    }

    public String getComponentType() {
        String fullname = this.getName();
        if (this.isArray()) {
            int end = fullname.length() - ARRAY_POSTFIX.length();
            return fullname.substring(0, end);
        }
        if (this.isMap()) {
            int end = fullname.length() - MAP_POSTFIX.length();
            return fullname.substring(0, end);
        }
        return fullname;
    }

    public boolean isArray() {
        return this.m_name.endsWith(ARRAY_POSTFIX);
    }

    public boolean isMap() {
        return this.m_name.endsWith(MAP_POSTFIX);
    }

    public boolean matches(ServiceDescriptor other) {
        String name = this.getComponentType();
        return other.getName().equals(name) && other.getVersion().complies(this.m_version);
    }

    public String toString() {
        return this.m_name + "/" + this.m_version;
    }
}

