/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.classman.builder;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.jar.Manifest;
import org.apache.avalon.excalibur.extension.Extension;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.excalibur.packagemanager.OptionalPackage;
import org.apache.avalon.excalibur.packagemanager.PackageManager;
import org.realityforge.classman.builder.LoaderResolver;
import org.realityforge.classman.runtime.JoinClassLoader;

public class SimpleLoaderResolver
implements LoaderResolver {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$realityforge$classman$builder$SimpleLoaderResolver == null ? (class$org$realityforge$classman$builder$SimpleLoaderResolver = SimpleLoaderResolver.class$("org.realityforge.classman.builder.SimpleLoaderResolver")) : class$org$realityforge$classman$builder$SimpleLoaderResolver));
    private File m_baseDirectory;
    private PackageManager m_manager;
    static /* synthetic */ Class class$org$realityforge$classman$builder$SimpleLoaderResolver;

    public SimpleLoaderResolver(File baseDirectory, PackageManager manager) {
        this.setBaseDirectory(baseDirectory);
        this.setManager(manager);
    }

    public URL resolveExtension(Extension extension) throws Exception {
        if (null == this.getManager()) {
            String message = REZ.getString("missing-packagemanager");
            throw new IllegalStateException(message);
        }
        OptionalPackage optionalPackage = this.getManager().getOptionalPackage(extension);
        return optionalPackage.getFile().toURL();
    }

    public URL resolveURL(String location) throws Exception {
        File file = this.getFileFor(location);
        String url = file.toURL().toString();
        if (file.isDirectory()) {
            url = url + "/";
        }
        return new URL(url);
    }

    public URL[] resolveFileSet(String baseDirectory, String[] includes, String[] excludes) throws Exception {
        throw new UnsupportedOperationException();
    }

    public ClassLoader createJoinClassLoader(ClassLoader[] classLoaders) throws Exception {
        return new JoinClassLoader(classLoaders, ClassLoader.getSystemClassLoader());
    }

    public ClassLoader createClassLoader(ClassLoader parent, URL[] urls) throws Exception {
        URL[] classpath = this.determineCompleteClasspath(urls);
        return new URLClassLoader(classpath, parent);
    }

    protected final URL[] determineCompleteClasspath(URL[] urls) throws Exception {
        ArrayList<URL> classpathSet = new ArrayList<URL>();
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            classpathSet.add(url);
            ++i;
        }
        File[] files = this.getOptionalPackagesFor(urls);
        int i2 = 0;
        while (i2 < files.length) {
            File file = files[i2];
            classpathSet.add(file.toURL());
            ++i2;
        }
        return classpathSet.toArray(new URL[classpathSet.size()]);
    }

    protected File getFileFor(String location) throws IOException {
        File base = this.getBaseDirectory();
        if (null == base) {
            base = new File(".");
        }
        return new File(base, location).getCanonicalFile();
    }

    protected File getBaseDirectory() {
        return this.m_baseDirectory;
    }

    protected void setBaseDirectory(File baseDirectory) {
        this.m_baseDirectory = baseDirectory;
    }

    protected PackageManager getManager() {
        return this.m_manager;
    }

    protected void setManager(PackageManager manager) {
        this.m_manager = manager;
    }

    protected final File[] getOptionalPackagesFor(URL[] classPath) throws Exception {
        Manifest[] manifests = this.getManifests(classPath);
        Extension[] available = Extension.getAvailable((Manifest[])manifests);
        Extension[] required = Extension.getRequired((Manifest[])manifests);
        if (this.isDebugEnabled()) {
            String message1 = REZ.getString("available-extensions", Arrays.asList(available));
            this.debug(message1);
            String message2 = REZ.getString("required-extensions", Arrays.asList(required));
            this.debug(message2);
        }
        if (0 == required.length) {
            return new File[0];
        }
        ArrayList dependencies = new ArrayList();
        ArrayList unsatisfied = new ArrayList();
        if (null == this.getManager()) {
            String message = REZ.getString("missing-packagemanager");
            throw new IllegalStateException(message);
        }
        this.m_manager.scanDependencies(required, available, dependencies, unsatisfied);
        if (0 != unsatisfied.size()) {
            int size = unsatisfied.size();
            int i = 0;
            while (i < size) {
                Extension extension = (Extension)unsatisfied.get(i);
                Object[] params = new Object[]{extension.getExtensionName(), extension.getSpecificationVendor(), extension.getSpecificationVersion(), extension.getImplementationVendor(), extension.getImplementationVendorID(), extension.getImplementationVersion(), extension.getImplementationURL()};
                String message = REZ.format("missing.extension", params);
                this.warn(message);
                ++i;
            }
            String message = REZ.getString("unsatisfied.extensions", (Object)new Integer(size));
            throw new Exception(message);
        }
        if (this.isDebugEnabled()) {
            String message = REZ.getString("optional-packages-added", dependencies);
            this.debug(message);
        }
        OptionalPackage[] packages = dependencies.toArray(new OptionalPackage[0]);
        return OptionalPackage.toFiles((OptionalPackage[])packages);
    }

    protected void warn(String message) {
    }

    protected boolean isDebugEnabled() {
        return false;
    }

    protected void debug(String message) {
    }

    private Manifest[] getManifests(URL[] classPath) throws Exception {
        ArrayList<Manifest> manifests = new ArrayList<Manifest>();
        int i = 0;
        while (i < classPath.length) {
            URL element = classPath[i];
            if (element.getFile().endsWith(".jar")) {
                try {
                    URL url = new URL("jar:" + element + "!/");
                    JarURLConnection connection = (JarURLConnection)url.openConnection();
                    Manifest manifest = connection.getManifest();
                    if (null != manifest) {
                        manifests.add(manifest);
                    }
                }
                catch (IOException ioe) {
                    String message = REZ.getString("bad-classpath-entry", (Object)element);
                    throw new Exception(message);
                }
            }
            ++i;
        }
        return manifests.toArray(new Manifest[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

