/*
 * Decompiled with CFR 0.152.
 */
package mx4j.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import mx4j.util.Utils;

public class StandardMBeanProxy {
    public static Object create(Class mbeanInterface, ObjectName name) {
        return StandardMBeanProxy.create(mbeanInterface, null, name);
    }

    public static Object create(Class mbeanInterface, MBeanServer server, ObjectName name) {
        if (mbeanInterface == null) {
            throw new IllegalArgumentException("MBean interface cannot be null");
        }
        if (!mbeanInterface.isInterface()) {
            throw new IllegalArgumentException("Class parameter must be an interface");
        }
        if (name == null) {
            throw new IllegalArgumentException("MBean name cannot be null");
        }
        if (server == null) {
            ArrayList<MBeanServer> list = MBeanServerFactory.findMBeanServer(null);
            if (list.size() > 0) {
                server = (MBeanServer)list.get(0);
            } else {
                throw new IllegalArgumentException("Cannot find MBeanServer");
            }
        }
        if (!server.isRegistered(name)) {
            throw new IllegalArgumentException("ObjectName " + name + " is not known to MBeanServer " + server);
        }
        ClassLoader loader = mbeanInterface.getClassLoader();
        return Proxy.newProxyInstance(loader, new Class[]{mbeanInterface}, (InvocationHandler)new LocalHandler(server, name));
    }

    private static class LocalHandler
    extends Handler {
        private MBeanServer m_server;
        private ObjectName m_name;

        private LocalHandler(MBeanServer server, ObjectName name) {
            this.m_server = server;
            this.m_name = name;
        }

        protected void setAttribute(Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            this.m_server.setAttribute(this.m_name, attribute);
        }

        protected Object getAttribute(String attribute) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException {
            return this.m_server.getAttribute(this.m_name, attribute);
        }

        protected Object invokeOperation(String method, Object[] args, String[] params) throws InstanceNotFoundException, MBeanException, ReflectionException {
            return this.m_server.invoke(this.m_name, method, args, params);
        }
    }

    protected static abstract class Handler
    implements InvocationHandler {
        protected Handler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            block11: {
                if (args == null) {
                    args = new Object[]{};
                }
                Class[] declared = method.getExceptionTypes();
                if (Utils.isAttributeSetter(method)) {
                    String name = method.getName().substring(3);
                    Attribute attribute = new Attribute(name, args[0]);
                    try {
                        this.setAttribute(attribute);
                        return null;
                    }
                    catch (Throwable x) {
                        this.unwrapThrowable(x, declared);
                    }
                } else {
                    if (Utils.isAttributeGetter(method)) {
                        String n = method.getName();
                        String name = null;
                        name = n.startsWith("is") ? n.substring(2) : n.substring(3);
                        try {
                            return this.getAttribute(name);
                        }
                        catch (Throwable x) {
                            this.unwrapThrowable(x, declared);
                            break block11;
                        }
                    }
                    Class<?>[] parameters = method.getParameterTypes();
                    String[] params = new String[parameters.length];
                    int i = 0;
                    while (i < parameters.length) {
                        params[i] = parameters[i].getName();
                        ++i;
                    }
                    try {
                        return this.invokeOperation(method.getName(), args, params);
                    }
                    catch (Throwable x) {
                        this.unwrapThrowable(x, declared);
                    }
                }
            }
            return null;
        }

        protected abstract void setAttribute(Attribute var1) throws Exception;

        protected abstract Object getAttribute(String var1) throws Exception;

        protected abstract Object invokeOperation(String var1, Object[] var2, String[] var3) throws Exception;

        protected void unwrapThrowable(Throwable x, Class[] declared) throws Throwable {
            if (declared != null) {
                int i = 0;
                while (i < declared.length) {
                    Class exception = declared[i];
                    if (exception.isInstance(x)) {
                        throw x;
                    }
                    ++i;
                }
            }
            if (x instanceof MBeanException) {
                this.unwrapThrowable(((MBeanException)x).getTargetException(), declared);
            } else if (x instanceof ReflectionException) {
                this.unwrapThrowable(((ReflectionException)x).getTargetException(), declared);
            } else if (x instanceof RuntimeOperationsException) {
                this.unwrapThrowable(((RuntimeOperationsException)x).getTargetException(), declared);
            } else if (x instanceof RuntimeMBeanException) {
                this.unwrapThrowable(((RuntimeMBeanException)x).getTargetException(), declared);
            } else if (x instanceof RuntimeErrorException) {
                this.unwrapThrowable(((RuntimeErrorException)x).getTargetError(), declared);
            } else {
                throw x;
            }
        }
    }
}

