/*
 * Decompiled with CFR 0.152.
 */
package mx4j.connector;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import mx4j.connector.MBeanServerConnection;
import mx4j.util.StandardMBeanProxy;

public class RemoteStandardMBeanProxy
extends StandardMBeanProxy {
    public static Object create(Class mbeanInterface, MBeanServerConnection server, ObjectName name) {
        if (mbeanInterface == null) {
            throw new IllegalArgumentException("MBean interface cannot be null");
        }
        if (!mbeanInterface.isInterface()) {
            throw new IllegalArgumentException("Class parameter must be an interface");
        }
        if (server == null) {
            throw new IllegalArgumentException("Remote MBeanServer cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("MBean name cannot be null");
        }
        ClassLoader loader = mbeanInterface.getClassLoader();
        return Proxy.newProxyInstance(loader, new Class[]{mbeanInterface}, (InvocationHandler)new RemoteHandler(server, name));
    }

    private static class RemoteHandler
    extends StandardMBeanProxy.Handler {
        private MBeanServerConnection m_server;
        private ObjectName m_name;

        private RemoteHandler(MBeanServerConnection server, ObjectName name) {
            this.m_server = server;
            this.m_name = name;
        }

        protected void setAttribute(Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            this.m_server.setAttribute(this.m_name, attribute);
        }

        protected Object getAttribute(String attribute) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, IOException {
            return this.m_server.getAttribute(this.m_name, attribute);
        }

        protected Object invokeOperation(String method, Object[] args, String[] params) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            return this.m_server.invoke(this.m_name, method, args, params);
        }
    }
}

