/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.framework.info;

import java.io.Serializable;
import java.util.Properties;

public final class Attribute
implements Serializable {
    public static final Attribute[] EMPTY_SET = new Attribute[0];
    private static final String[] EMPTY_NAME_SET = new String[0];
    private final String m_name;
    private final Properties m_parameters;

    public Attribute(String name, Properties parameters) {
        if (null == name) {
            throw new NullPointerException("name");
        }
        this.m_name = name;
        this.m_parameters = parameters;
    }

    public String getName() {
        return this.m_name;
    }

    public String getParameter(String key) {
        if (null == this.m_parameters) {
            return null;
        }
        return this.m_parameters.getProperty(key);
    }

    public String getParameter(String key, String defaultValue) {
        if (null == this.m_parameters) {
            return defaultValue;
        }
        return this.m_parameters.getProperty(key, defaultValue);
    }

    public String[] getParameterNames() {
        if (null == this.m_parameters) {
            return EMPTY_NAME_SET;
        }
        return this.m_parameters.keySet().toArray(EMPTY_NAME_SET);
    }

    public String toString() {
        if (null != this.m_parameters) {
            return this.getName() + this.m_parameters;
        }
        return this.getName();
    }
}

