/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.containerkit.verifier;

import java.util.ArrayList;
import java.util.Stack;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.containerkit.metadata.DependencyMetaData;
import org.apache.avalon.phoenix.containerkit.profile.ComponentProfile;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.framework.info.DependencyDescriptor;
import org.apache.avalon.phoenix.framework.info.ServiceDescriptor;
import org.apache.avalon.phoenix.framework.tools.verifier.VerifyException;

public class AssemblyVerifier
extends AbstractLogEnabled {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$containerkit$verifier$AssemblyVerifier == null ? (class$org$apache$avalon$phoenix$containerkit$verifier$AssemblyVerifier = AssemblyVerifier.class$("org.apache.avalon.phoenix.containerkit.verifier.AssemblyVerifier")) : class$org$apache$avalon$phoenix$containerkit$verifier$AssemblyVerifier));
    static /* synthetic */ Class class$org$apache$avalon$phoenix$containerkit$verifier$AssemblyVerifier;

    public void verifyAssembly(ComponentProfile[] components) throws VerifyException {
        String message = REZ.getString("assembly.valid-names.notice");
        this.getLogger().info(message);
        this.verifyValidNames(components);
        message = REZ.getString("assembly.unique-names.notice");
        this.getLogger().info(message);
        this.checkNamesUnique(components);
        message = REZ.getString("assembly.dependencies-mapping.notice");
        this.getLogger().info(message);
        this.verifyValidDependencies(components);
        message = REZ.getString("assembly.dependency-references.notice");
        this.getLogger().info(message);
        this.verifyDependencyReferences(components);
        message = REZ.getString("assembly.nocircular-dependencies.notice");
        this.getLogger().info(message);
        this.verifyNoCircularDependencies(components);
    }

    public void verifyValidDependencies(ComponentProfile[] components) throws VerifyException {
        for (int i = 0; i < components.length; ++i) {
            this.verifyDependenciesMap(components[i]);
        }
    }

    protected void verifyNoCircularDependencies(ComponentProfile[] components) throws VerifyException {
        for (int i = 0; i < components.length; ++i) {
            ComponentProfile component = components[i];
            Stack<ComponentProfile> stack = new Stack<ComponentProfile>();
            stack.push(component);
            this.verifyNoCircularDependencies(component, components, stack);
            stack.pop();
        }
    }

    protected void verifyNoCircularDependencies(ComponentProfile component, ComponentProfile[] components, Stack stack) throws VerifyException {
        ComponentProfile[] dependencies = this.getDependencies(component, components);
        for (int i = 0; i < dependencies.length; ++i) {
            ComponentProfile dependency = dependencies[i];
            if (stack.contains(dependency)) {
                String trace = this.getDependencyTrace(dependency, stack);
                String message = REZ.getString("assembly.circular-dependency.error", (Object)component.getMetaData().getName(), (Object)trace);
                throw new VerifyException(message);
            }
            stack.push(dependency);
            this.verifyNoCircularDependencies(dependency, components, stack);
            stack.pop();
        }
    }

    protected String getDependencyTrace(ComponentProfile component, Stack stack) {
        int top;
        StringBuffer sb = new StringBuffer();
        sb.append("[ ");
        String name = component.getMetaData().getName();
        int size = stack.size();
        for (int i = top = size - 1; i >= 0; --i) {
            ComponentProfile other = (ComponentProfile)stack.get(i);
            if (top != i) {
                sb.append(", ");
            }
            sb.append(other.getMetaData().getName());
            if (other.getMetaData().getName().equals(name)) break;
        }
        sb.append(", ");
        sb.append(name);
        sb.append(" ]");
        return sb.toString();
    }

    protected ComponentProfile[] getDependencies(ComponentProfile component, ComponentProfile[] components) {
        ArrayList<ComponentProfile> dependencies = new ArrayList<ComponentProfile>();
        DependencyMetaData[] deps = component.getMetaData().getDependencies();
        for (int i = 0; i < deps.length; ++i) {
            String name = deps[i].getProviderName();
            ComponentProfile other = this.getComponentProfile(name, components);
            dependencies.add(other);
        }
        return dependencies.toArray(new ComponentProfile[0]);
    }

    protected void verifyDependencyReferences(ComponentProfile[] components) throws VerifyException {
        for (int i = 0; i < components.length; ++i) {
            this.verifyDependencyReferences(components[i], components);
        }
    }

    protected void verifyDependencyReferences(ComponentProfile component, ComponentProfile[] others) throws VerifyException {
        ComponentInfo info = component.getInfo();
        DependencyMetaData[] dependencies = component.getMetaData().getDependencies();
        for (int i = 0; i < dependencies.length; ++i) {
            DependencyMetaData dependency = dependencies[i];
            String providerName = dependency.getProviderName();
            String key = dependency.getKey();
            String type = info.getDependency(key).getComponentType();
            ComponentProfile provider = this.getComponentProfile(providerName, others);
            if (null == provider) {
                String message = REZ.getString("assembly.missing-dependency.error", (Object)key, (Object)providerName, (Object)component.getMetaData().getName());
                throw new VerifyException(message);
            }
            ComponentInfo providerInfo = provider.getInfo();
            ServiceDescriptor[] services = providerInfo.getServices();
            if (this.hasMatchingService(type, services)) continue;
            String message = REZ.getString("assembly.dependency-missing-service.error", (Object)providerName, (Object)type, (Object)component.getMetaData().getName());
            throw new VerifyException(message);
        }
    }

    protected ComponentProfile getComponentProfile(String name, ComponentProfile[] components) {
        for (int i = 0; i < components.length; ++i) {
            ComponentProfile ComponentProfile2 = components[i];
            if (!ComponentProfile2.getMetaData().getName().equals(name)) continue;
            return components[i];
        }
        return null;
    }

    protected void verifyValidNames(ComponentProfile[] components) throws VerifyException {
        for (int i = 0; i < components.length; ++i) {
            ComponentProfile ComponentProfile2 = components[i];
            String name = ComponentProfile2.getMetaData().getName();
            if (this.isValidName(name)) continue;
            String message = REZ.getString("assembly.bad-name.error", (Object)name);
            throw new VerifyException(message);
        }
    }

    protected boolean isValidName(String name) {
        int size = name.length();
        for (int i = 0; i < size; ++i) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch) || '-' == ch) continue;
            return false;
        }
        return true;
    }

    protected void checkNamesUnique(ComponentProfile[] components) throws VerifyException {
        for (int i = 0; i < components.length; ++i) {
            ComponentProfile ComponentProfile2 = components[i];
            String name = ComponentProfile2.getMetaData().getName();
            this.verifyUniqueName(components, name, i);
        }
    }

    private void verifyUniqueName(ComponentProfile[] components, String name, int index) throws VerifyException {
        for (int i = 0; i < components.length; ++i) {
            ComponentProfile ComponentProfile2 = components[i];
            String other = ComponentProfile2.getMetaData().getName();
            if (index == i || !other.equals(name)) continue;
            String message = REZ.getString("assembly.duplicate-name.error", (Object)name);
            throw new VerifyException(message);
        }
    }

    protected void verifyDependenciesMap(ComponentProfile component) throws VerifyException {
        DependencyMetaData[] dependencySet = component.getMetaData().getDependencies();
        for (int i = 0; i < dependencySet.length; ++i) {
            String key = dependencySet[i].getKey();
            ComponentInfo info = component.getInfo();
            DependencyDescriptor descriptor = info.getDependency(key);
            if (null != descriptor) continue;
            String message = REZ.getString("assembly.unknown-dependency.error", (Object)key, (Object)key, (Object)component.getMetaData().getName());
            throw new VerifyException(message);
        }
        ComponentInfo info = component.getInfo();
        DependencyDescriptor[] dependencies = info.getDependencies();
        for (int i = 0; i < dependencies.length; ++i) {
            DependencyDescriptor dependency = dependencies[i];
            DependencyMetaData dependencyMetaData = component.getMetaData().getDependency(dependency.getKey());
            if (null != dependencyMetaData || dependency.isOptional()) continue;
            String message = REZ.getString("assembly.unspecified-dependency.error", (Object)dependency.getKey(), (Object)component.getMetaData().getName());
            throw new VerifyException(message);
        }
    }

    protected boolean hasMatchingService(String type, ServiceDescriptor[] candidates) {
        for (int i = 0; i < candidates.length; ++i) {
            String otherClassname = candidates[i].getType();
            if (!otherClassname.equals(type)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

