/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.containerkit.factory;

import java.util.Map;
import java.util.WeakHashMap;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.containerkit.factory.ComponentBundle;
import org.apache.avalon.phoenix.containerkit.factory.ComponentFactory;
import org.apache.avalon.phoenix.containerkit.factory.DefaultComponentBundle;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.framework.tools.infobuilder.InfoBuilder;

public class DefaultComponentFactory
extends AbstractLogEnabled
implements ComponentFactory {
    private final Map m_infos = new WeakHashMap();
    private final InfoBuilder m_infoBuilder = new InfoBuilder();
    private final ClassLoader m_classLoader;

    public DefaultComponentFactory(ClassLoader classLoader) {
        if (null == classLoader) {
            throw new NullPointerException("classLoader");
        }
        this.m_classLoader = classLoader;
    }

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.setupLogger((Object)this.m_infoBuilder, "info");
    }

    public ComponentBundle createBundle(String implementationKey) throws Exception {
        ComponentBundle bundle = (ComponentBundle)this.m_infos.get(implementationKey);
        if (null == bundle) {
            bundle = this.newBundle(implementationKey);
            this.m_infos.put(implementationKey, bundle);
        }
        return bundle;
    }

    public Object createComponent(String implementationKey) throws Exception {
        Class<?> clazz = this.getClassLoader().loadClass(implementationKey);
        return clazz.newInstance();
    }

    protected ComponentBundle newBundle(String implementationKey) throws Exception {
        ComponentInfo info = this.createComponentInfo(implementationKey);
        DefaultComponentBundle bundle = new DefaultComponentBundle(info, this.getClassLoader());
        return bundle;
    }

    protected ComponentInfo createComponentInfo(String implementationKey) throws Exception {
        return this.m_infoBuilder.buildComponentInfo(implementationKey, this.getClassLoader());
    }

    protected ClassLoader getClassLoader() {
        return this.m_classLoader;
    }
}

