/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.configkit;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.realityforge.configkit.CatalogHandler;
import org.realityforge.configkit.ConfigKitEntityResolver;
import org.realityforge.configkit.EntityInfo;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class ResolverFactory {
    private static final String CATALOG_RESOURCE = "META-INF/spice/catalog.xml";

    public static final EntityResolver createResolver(ClassLoader classLoader) throws ParserConfigurationException, SAXException, IOException {
        if (null == classLoader) {
            throw new NullPointerException("classLoader");
        }
        ArrayList entitys = new ArrayList();
        Enumeration<URL> resources = classLoader.getResources(CATALOG_RESOURCE);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            ResolverFactory.parseCatalog(url, entitys);
        }
        EntityInfo[] infos = entitys.toArray(new EntityInfo[entitys.size()]);
        return new ConfigKitEntityResolver(infos, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseCatalog(URL url, List entitys) throws ParserConfigurationException, SAXException, IOException {
        InputStream inputStream = url.openStream();
        try {
            XMLReader xmlReader = ResolverFactory.createXMLReader();
            CatalogHandler handler = new CatalogHandler(entitys);
            xmlReader.setContentHandler(handler);
            xmlReader.setErrorHandler(handler);
            xmlReader.parse(new InputSource(inputStream));
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                inputStream.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException ioe) {}
    }

    private static XMLReader createXMLReader() throws SAXException, ParserConfigurationException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(false);
        return saxParserFactory.newSAXParser().getXMLReader();
    }

    static {
        CATALOG_RESOURCE = CATALOG_RESOURCE;
    }
}

