/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.configkit;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class PropertyExpander {
    public static final int LEAVE_UNDEFINED = 1;
    public static final int EXCEPT_ON_UNDEFINED = 2;
    public static final int EMPTY_ON_UNDEFINED = 3;
    private final int m_onUndefined;

    public PropertyExpander() {
        this(2);
    }

    public PropertyExpander(int onUndefined) {
        this.m_onUndefined = onUndefined;
    }

    public Properties expandValues(Properties input, Map data) throws Exception {
        Properties result = new Properties();
        Iterator<Object> iterator = input.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = input.getProperty(key);
            String newKey = this.expandValues(key, data);
            String newValue = this.expandValues(value, data);
            result.setProperty(newKey, newValue);
        }
        return result;
    }

    public void expandValues(Element input, Map data) throws Exception {
        NamedNodeMap attributes = input.getAttributes();
        int attributeCount = attributes.getLength();
        int i = 0;
        while (i < attributeCount) {
            Attr attr = (Attr)attributes.item(i);
            String value = attr.getValue();
            String newValue = this.expandValues(value, data);
            attr.setValue(newValue);
            ++i;
        }
        NodeList nodes = input.getChildNodes();
        int childCount = nodes.getLength();
        int i2 = 0;
        while (i2 < childCount) {
            Node node = nodes.item(i2);
            if (node instanceof Element) {
                this.expandValues((Element)node, data);
            } else if (node instanceof Text) {
                Text text = (Text)node;
                String content = text.getData();
                String newContent = this.expandValues(content, data);
                text.setData(newContent);
            }
            ++i2;
        }
    }

    public String expandValues(String input, Map data) throws Exception {
        int start = this.findBeginning(input, 0);
        if (-1 == start) {
            return input;
        }
        int end = this.findEnding(input, start);
        int length = input.length();
        if (0 == start && end == length - 1) {
            return this.getValue(input.substring(start + 2, end), data);
        }
        StringBuffer sb = new StringBuffer(length * 2);
        int lastPlace = 0;
        while (true) {
            String value = this.getValue(input.substring(start + 2, end), data);
            sb.append(input.substring(lastPlace, start));
            sb.append(value);
            lastPlace = end + 1;
            start = this.findBeginning(input, lastPlace);
            if (-1 == start) break;
            end = this.findEnding(input, start);
        }
        sb.append(input.substring(lastPlace, length));
        return sb.toString();
    }

    private int findBeginning(String input, int index) {
        return input.indexOf("${", index);
    }

    private int findEnding(String input, int index) throws Exception {
        int end = input.indexOf(125, index);
        if (-1 == end) {
            String message = "Malformed input with mismatched }'s";
            throw new Exception("Malformed input with mismatched }'s");
        }
        return end;
    }

    private String getValue(String key, Map data) throws Exception {
        Object value = data.get(key);
        if (null == value) {
            if (1 == this.m_onUndefined) {
                return "${" + key + "}";
            }
            if (3 == this.m_onUndefined) {
                return "";
            }
            String message = "Unable to find " + key + " to expand during property resolution.";
            throw new Exception(message);
        }
        return String.valueOf(value);
    }

    static {
        LEAVE_UNDEFINED = 1;
        EXCEPT_ON_UNDEFINED = 2;
        EMPTY_ON_UNDEFINED = 3;
    }
}

