/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.thread.impl;

import org.apache.excalibur.thread.ThreadControl;

final class DefaultThreadControl
implements ThreadControl {
    private Thread m_thread;
    private Throwable m_throwable;

    protected DefaultThreadControl(Thread thread) {
        this.m_thread = thread;
    }

    public synchronized void join(long milliSeconds) throws IllegalStateException, InterruptedException {
        if (!this.isFinished()) {
            this.m_thread.wait(milliSeconds);
        }
    }

    public void interupt() throws IllegalStateException, SecurityException {
        this.interrupt();
    }

    public synchronized void interrupt() throws IllegalStateException, SecurityException {
        if (!this.isFinished()) {
            this.m_thread.interrupt();
        }
    }

    public synchronized boolean isFinished() {
        return null == this.m_thread;
    }

    public Throwable getThrowable() {
        return this.m_throwable;
    }

    protected synchronized void finish(Throwable throwable) {
        this.m_thread = null;
        this.m_throwable = throwable;
        this.notifyAll();
    }
}

