/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.util;

import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Resolvable;

public final class PropertyUtil {
    private PropertyUtil() {
    }

    public static Object resolveProperty(String property, Context context, boolean ignoreUndefined) throws Exception {
        int start = PropertyUtil.findBeginning(property, 0);
        if (-1 == start) {
            return property;
        }
        int end = PropertyUtil.findEnding(property, start);
        int length = property.length();
        if (0 == start && end == length - 1) {
            return PropertyUtil.resolveValue(property.substring(start + 2, end), context, ignoreUndefined);
        }
        StringBuffer sb = new StringBuffer(length * 2);
        int lastPlace = 0;
        while (true) {
            Object value = PropertyUtil.resolveValue(property.substring(start + 2, end), context, ignoreUndefined);
            sb.append(property.substring(lastPlace, start));
            sb.append(value);
            lastPlace = end + 1;
            start = PropertyUtil.findBeginning(property, lastPlace);
            if (-1 == start) break;
            end = PropertyUtil.findEnding(property, start);
        }
        sb.append(property.substring(lastPlace, length));
        return sb.toString();
    }

    private static int findBeginning(String property, int currentPosition) {
        return property.indexOf("${", currentPosition);
    }

    private static int findEnding(String property, int currentPosition) throws Exception {
        int index = property.indexOf(125, currentPosition);
        if (-1 == index) {
            throw new Exception("Malformed property with mismatched }'s");
        }
        return index;
    }

    private static Object resolveValue(String key, Context context, boolean ignoreUndefined) throws Exception {
        Object value = null;
        try {
            value = context.get((Object)key);
        }
        catch (ContextException ce) {
            // empty catch block
        }
        try {
            while (null != value && value instanceof Resolvable) {
                value = ((Resolvable)value).resolve(context);
            }
        }
        catch (ContextException ce) {
            throw new Exception("Unable to resolve value for key " + key);
        }
        if (null == value) {
            if (ignoreUndefined) {
                return "";
            }
            throw new Exception("Unable to find " + key + " to expand during " + "property resolution.");
        }
        return value;
    }
}

