/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.kernel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.phoenix.components.util.ResourceUtil;
import org.apache.avalon.phoenix.containerkit.profile.PartitionProfile;
import org.apache.avalon.phoenix.interfaces.ApplicationContext;
import org.apache.avalon.phoenix.interfaces.Kernel;
import org.apache.avalon.phoenix.interfaces.ManagerException;
import org.apache.avalon.phoenix.interfaces.SystemManager;
import org.apache.excalibur.instrument.InstrumentManager;
import org.realityforge.loggerstore.LoggerStore;

class DefaultApplicationContext
extends AbstractLogEnabled
implements ApplicationContext,
Serviceable,
Initializable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$components$kernel$DefaultApplicationContext == null ? (class$org$apache$avalon$phoenix$components$kernel$DefaultApplicationContext = DefaultApplicationContext.class$("org.apache.avalon.phoenix.components.kernel.DefaultApplicationContext")) : class$org$apache$avalon$phoenix$components$kernel$DefaultApplicationContext));
    private final LoggerStore m_store;
    private final ClassLoader m_classLoader;
    private InstrumentManager m_instrumentManager;
    private SystemManager m_systemManager;
    private SystemManager m_blockManager;
    private final PartitionProfile m_profile;
    private final File m_workDirectory;
    private final File m_homeDirectory;
    private final Map m_loaders;
    private Kernel m_kernel;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$components$kernel$DefaultApplicationContext;

    protected DefaultApplicationContext(PartitionProfile profile, File homeDirectory, File workDirectory, ClassLoader classLoader, LoggerStore store, Map loaders) {
        if (null == profile) {
            throw new NullPointerException("profile");
        }
        if (null == classLoader) {
            throw new NullPointerException("classLoader");
        }
        if (null == store) {
            throw new NullPointerException("store");
        }
        if (null == workDirectory) {
            throw new NullPointerException("workDirectory");
        }
        if (null == homeDirectory) {
            throw new NullPointerException("homeDirectory");
        }
        this.m_profile = profile;
        this.m_classLoader = classLoader;
        this.m_store = store;
        this.m_workDirectory = workDirectory;
        this.m_homeDirectory = homeDirectory;
        this.m_loaders = loaders;
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_systemManager = (SystemManager)serviceManager.lookup(SystemManager.ROLE);
        this.m_kernel = (Kernel)serviceManager.lookup(Kernel.ROLE);
        this.m_instrumentManager = (InstrumentManager)serviceManager.lookup(InstrumentManager.ROLE);
    }

    public void initialize() throws Exception {
        this.m_blockManager = this.getManagementContext();
    }

    public InputStream getResourceAsStream(String name) {
        File file = ResourceUtil.getFileForResource(name, this.getHomeDirectory(), this.m_workDirectory);
        if (!file.exists()) {
            return null;
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public PartitionProfile getPartitionProfile() {
        return this.m_profile;
    }

    public void requestShutdown() {
        Thread thread = new Thread("AppShutdown"){

            public void run() {
                DefaultApplicationContext.this.scheduleShutdown();
            }
        };
        thread.start();
    }

    private void scheduleShutdown() {
        try {
            Thread.sleep(2L);
            this.m_kernel.removeApplication(this.getName());
        }
        catch (Exception e) {
            String message = REZ.getString("applicationcontext.error.noremove", (Object)this.getName());
            this.getLogger().error(message, (Throwable)e);
        }
    }

    public File getHomeDirectory() {
        return this.m_homeDirectory;
    }

    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    public Logger getLogger(String category) throws Exception {
        return this.m_store.getLogger(category);
    }

    public void exportObject(String name, Class[] services, Object object) throws Exception {
        this.m_blockManager.register(name, object, services);
    }

    public void unexportObject(String name) throws Exception {
        this.m_blockManager.unregister(name);
    }

    public ClassLoader getClassLoader(String name) throws Exception {
        ClassLoader classLoader = (ClassLoader)this.m_loaders.get(name);
        if (null == classLoader) {
            String message = REZ.getString("applicationcontext.error.noloader", (Object)name);
            throw new Exception(message);
        }
        return classLoader;
    }

    private SystemManager getManagementContext() throws ManagerException {
        SystemManager appContext = this.m_systemManager.getSubContext(null, "application");
        return appContext.getSubContext(this.getName(), "block");
    }

    public InstrumentManager getInstrumentManager() {
        return this.m_instrumentManager;
    }

    public String getInstrumentableName(String component) {
        return "applications." + this.getName() + "." + component;
    }

    private String getName() {
        return this.m_profile.getMetaData().getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

