/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.application;

import java.io.File;
import java.io.InputStream;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.BlockContext;
import org.apache.avalon.phoenix.interfaces.ApplicationContext;

final class DefaultBlockContext
implements BlockContext {
    private final String m_name;
    private final ApplicationContext m_applicationContext;

    DefaultBlockContext(String name, ApplicationContext frame) {
        this.m_name = name;
        this.m_applicationContext = frame;
    }

    public Object get(Object key) throws ContextException {
        if ("app.name".equals(key)) {
            return this.m_applicationContext.getPartitionProfile().getMetaData().getName();
        }
        if ("app.home".equals(key)) {
            return this.m_applicationContext.getHomeDirectory();
        }
        if ("block.name".equals(key)) {
            return this.m_name;
        }
        throw new ContextException("Unknown key: " + key);
    }

    public File getBaseDirectory() {
        return this.m_applicationContext.getHomeDirectory();
    }

    public String getName() {
        return this.m_name;
    }

    public void requestShutdown() {
        this.m_applicationContext.requestShutdown();
    }

    public InputStream getResourceAsStream(String name) {
        return this.m_applicationContext.getResourceAsStream(name);
    }

    public Logger getLogger(String name) {
        try {
            return this.m_applicationContext.getLogger(this.getName()).getChildLogger(name);
        }
        catch (Exception e) {
            String message = "Unable to aquire logger " + name + " due to " + e;
            throw new IllegalStateException(message);
        }
    }

    public ClassLoader getClassLoader(String name) throws Exception {
        return this.m_applicationContext.getClassLoader(name);
    }
}

