/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.util;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class ResourceUtil {
    private static final String SAR_PROTOCOL = "sar:";
    private static final String SAR_INF = "SAR-INF/";
    private static final String CLASSES = "SAR-INF/classes";
    private static final String LIB = "SAR-INF/lib";

    public static String expandSarURL(String codeBase, File baseDirectory, File workDirectory) throws ConfigurationException {
        if (codeBase.startsWith(SAR_PROTOCOL)) {
            File file = ResourceUtil.getFileForResource(codeBase.substring(4), baseDirectory, workDirectory);
            try {
                return file.toURL().toString();
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
        return codeBase;
    }

    public static File getFileForResource(String location, File baseDirectory, File workDirectory) {
        String filename = location.replace('/', File.separatorChar);
        if (filename.startsWith("/")) {
            filename = filename.substring(1);
        }
        File baseDir = ResourceUtil.getBaseDirectoryFor(location, baseDirectory, workDirectory);
        return new File(baseDir, filename);
    }

    private static File getBaseDirectoryFor(String location, File baseDirectory, File workDirectory) {
        if (location.startsWith(CLASSES) || location.startsWith(LIB)) {
            return workDirectory;
        }
        return baseDirectory;
    }
}

