/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.classloader;

import java.io.File;
import java.net.URL;
import java.security.Policy;
import java.util.Map;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.components.classloader.SarPolicy;
import org.apache.avalon.phoenix.components.util.ResourceUtil;
import org.realityforge.xmlpolicy.builder.PolicyResolver;

class SarPolicyResolver
extends AbstractLogEnabled
implements PolicyResolver {
    private final File m_baseDirectory;
    private final File m_workDirectory;

    SarPolicyResolver(File baseDirectory, File workDirectory) {
        this.m_workDirectory = workDirectory;
        this.m_baseDirectory = baseDirectory;
    }

    public Policy createPolicy(Map grants) throws Exception {
        SarPolicy sarPolicy = new SarPolicy(grants);
        ContainerUtil.enableLogging((Object)((Object)sarPolicy), (Logger)this.getLogger());
        ContainerUtil.initialize((Object)((Object)sarPolicy));
        return sarPolicy;
    }

    public URL resolveLocation(String location) throws Exception {
        if (null == location) {
            return null;
        }
        location = ResourceUtil.expandSarURL(location, this.m_baseDirectory, this.m_workDirectory);
        return new URL(location);
    }
}

