/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.classloader;

import java.io.File;
import java.net.URL;
import java.security.Policy;
import java.util.Arrays;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.components.classloader.DefaultLoaderResolver;
import org.apache.avalon.phoenix.components.classloader.PolicyClassLoader;
import org.apache.avalon.phoenix.components.extensions.pkgmgr.PackageManager;
import org.apache.avalon.phoenix.components.util.ResourceUtil;

class SarLoaderResolver
extends DefaultLoaderResolver
implements LogEnabled {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$components$classloader$SarLoaderResolver == null ? (class$org$apache$avalon$phoenix$components$classloader$SarLoaderResolver = SarLoaderResolver.class$("org.apache.avalon.phoenix.components.classloader.SarLoaderResolver")) : class$org$apache$avalon$phoenix$components$classloader$SarLoaderResolver));
    private Logger m_logger;
    private Policy m_policy;
    private File m_workDirectory;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$components$classloader$SarLoaderResolver;

    SarLoaderResolver(PackageManager manager, Policy policy, File baseDirectory, File workDirectory) {
        super(baseDirectory, manager);
        if (null == policy) {
            throw new NullPointerException("policy");
        }
        if (null == baseDirectory) {
            throw new NullPointerException("baseDirectory");
        }
        if (null == workDirectory) {
            throw new NullPointerException("workDirectory");
        }
        this.m_policy = policy;
        this.m_workDirectory = workDirectory;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public URL resolveURL(String location) throws Exception {
        File file = ResourceUtil.getFileForResource(location, this.getBaseDirectory(), this.m_workDirectory);
        return file.toURL();
    }

    public URL[] resolveFileSet(String baseDirectory, String[] includes, String[] excludes) throws Exception {
        URL[] baseURLs = this.resolveFileSet(this.getBaseDirectory(), baseDirectory, includes, excludes);
        URL[] workURLs = this.resolveFileSet(this.m_workDirectory, baseDirectory, includes, excludes);
        URL[] urls = new URL[baseURLs.length + workURLs.length];
        System.arraycopy(baseURLs, 0, urls, 0, baseURLs.length);
        System.arraycopy(workURLs, 0, urls, baseURLs.length, workURLs.length);
        return urls;
    }

    public ClassLoader createClassLoader(ClassLoader parent, URL[] urls) throws Exception {
        URL[] classpath = this.determineCompleteClasspath(urls);
        if (this.m_logger.isDebugEnabled()) {
            String message = REZ.getString("resolver.loader-urls.notice", Arrays.asList(classpath));
            this.m_logger.debug(message);
        }
        PolicyClassLoader loader = new PolicyClassLoader(classpath, parent, this.m_policy);
        ContainerUtil.enableLogging((Object)loader, (Logger)this.m_logger);
        return loader;
    }

    protected void debug(String message) {
        this.m_logger.debug(message);
    }

    protected boolean isDebugEnabled() {
        return this.m_logger.isDebugEnabled();
    }

    protected void warn(String message) {
        this.m_logger.warn(message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

