/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.classloader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.Enumeration;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;

class PolicyClassLoader
extends URLClassLoader
implements LogEnabled {
    private final Policy m_policy;
    private Logger m_logger;

    PolicyClassLoader(URL[] urls, ClassLoader parent, Policy policy) throws MalformedURLException {
        super(urls, parent);
        if (null == policy) {
            throw new NullPointerException("policy");
        }
        this.m_policy = policy;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    protected void addURL(URL url) {
        super.addURL(url);
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("findClass(" + name + ")");
        }
        return super.findClass(name);
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("getPermissions(" + codeSource + ")");
        }
        return this.m_policy.getPermissions(codeSource);
    }

    public Enumeration findResources(String name) throws IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("findResources(" + name + ")");
        }
        return super.findResources(name);
    }

    public URL findResource(String name) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("findResource(" + name + ")");
        }
        URL url = super.findResource(name);
        if (this.getLogger().isDebugEnabled()) {
            if (null != url) {
                this.getLogger().debug("Resource " + name + " located (" + url + ")");
            } else {
                this.getLogger().debug("Resource " + name + " not located");
            }
        }
        return url;
    }
}

