/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.assembler;

import java.util.ArrayList;
import java.util.Map;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.components.assembler.AssemblyException;
import org.apache.avalon.phoenix.containerkit.metadata.ComponentMetaData;
import org.apache.avalon.phoenix.containerkit.metadata.DependencyMetaData;
import org.apache.avalon.phoenix.containerkit.metadata.MetaDataBuilder;
import org.apache.avalon.phoenix.containerkit.metadata.PartitionMetaData;
import org.apache.avalon.phoenix.framework.info.Attribute;

public class Assembler
extends AbstractLogEnabled
implements MetaDataBuilder {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$components$assembler$Assembler == null ? (class$org$apache$avalon$phoenix$components$assembler$Assembler = Assembler.class$("org.apache.avalon.phoenix.components.assembler.Assembler")) : class$org$apache$avalon$phoenix$components$assembler$Assembler));
    static /* synthetic */ Class class$org$apache$avalon$phoenix$components$assembler$Assembler;

    public PartitionMetaData buildAssembly(Map parameters) throws Exception {
        String name = (String)parameters.get("phoenix:assembly-name");
        Configuration assembly = (Configuration)parameters.get("phoenix:assembly");
        Configuration config = (Configuration)parameters.get("phoenix:config");
        return this.assembleSar(name, config, assembly);
    }

    private PartitionMetaData assembleSar(String name, Configuration config, Configuration assembly) throws AssemblyException {
        Configuration[] blockConfig = assembly.getChildren("block");
        ComponentMetaData[] blocks = this.buildBlocks(blockConfig, config);
        PartitionMetaData blockPartition = new PartitionMetaData("block", new String[]{"listener"}, PartitionMetaData.EMPTY_SET, blocks, Attribute.EMPTY_SET);
        Configuration[] listenerConfig = assembly.getChildren("listener");
        ComponentMetaData[] listeners = this.buildBlockListeners(listenerConfig, config);
        PartitionMetaData listenerPartition = new PartitionMetaData("listener", new String[0], PartitionMetaData.EMPTY_SET, listeners, Attribute.EMPTY_SET);
        PartitionMetaData[] partitions = new PartitionMetaData[]{blockPartition, listenerPartition};
        return new PartitionMetaData(name, new String[0], partitions, new ComponentMetaData[0], Attribute.EMPTY_SET);
    }

    private ComponentMetaData[] buildBlocks(Configuration[] blocks, Configuration config) throws AssemblyException {
        ArrayList<ComponentMetaData> blockSet = new ArrayList<ComponentMetaData>();
        for (int i = 0; i < blocks.length; ++i) {
            blockSet.add(this.buildBlock(blocks[i], config));
        }
        return blockSet.toArray(new ComponentMetaData[blockSet.size()]);
    }

    private ComponentMetaData buildBlock(Configuration block, Configuration config) throws AssemblyException {
        try {
            String name = block.getAttribute("name");
            String classname = block.getAttribute("class");
            Configuration proxy = block.getChild("proxy");
            ArrayList<Attribute> attributeSet = new ArrayList<Attribute>();
            boolean disableProxy = proxy.getAttributeAsBoolean("disable", false);
            if (disableProxy) {
                Attribute attribute = new Attribute("phoenix:disable-proxy", null);
                attributeSet.add(attribute);
            }
            Configuration[] provides = block.getChildren("provide");
            DependencyMetaData[] dependencys = this.buildDependencies(provides);
            Attribute[] attributes = attributeSet.toArray(new Attribute[attributeSet.size()]);
            Configuration configuration = config.getChild(name);
            return new ComponentMetaData(name, classname, dependencys, null, configuration, attributes);
        }
        catch (ConfigurationException ce) {
            String message = REZ.getString("block-entry-malformed", (Object)block.getLocation(), (Object)ce.getMessage());
            throw new AssemblyException(message, ce);
        }
    }

    private ComponentMetaData[] buildBlockListeners(Configuration[] listenerConfigs, Configuration config) throws AssemblyException {
        ArrayList<ComponentMetaData> listeners = new ArrayList<ComponentMetaData>();
        for (int i = 0; i < listenerConfigs.length; ++i) {
            ComponentMetaData listener = this.buildBlockListener(listenerConfigs[i], config);
            listeners.add(listener);
        }
        return listeners.toArray(new ComponentMetaData[listeners.size()]);
    }

    private ComponentMetaData buildBlockListener(Configuration listener, Configuration config) throws AssemblyException {
        try {
            String name = listener.getAttribute("name");
            String classname = listener.getAttribute("class");
            Configuration configuration = config.getChild(name);
            return new ComponentMetaData(name, classname, new DependencyMetaData[0], null, configuration, Attribute.EMPTY_SET);
        }
        catch (ConfigurationException ce) {
            String message = REZ.getString("listener-entry-malformed", (Object)listener.getLocation(), (Object)ce.getMessage());
            throw new AssemblyException(message, ce);
        }
    }

    private DependencyMetaData[] buildDependencies(Configuration[] provides) throws ConfigurationException {
        ArrayList<DependencyMetaData> dependencies = new ArrayList<DependencyMetaData>();
        for (int j = 0; j < provides.length; ++j) {
            Configuration provide = provides[j];
            String requiredName = provide.getAttribute("name");
            String alias = provide.getAttribute("alias", requiredName);
            String key = provide.getAttribute("role");
            dependencies.add(new DependencyMetaData(key, requiredName, alias, Attribute.EMPTY_SET));
        }
        return dependencies.toArray(new DependencyMetaData[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

